/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.templating.impl;

import groovy.lang.GroovyClassLoader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.codehaus.groovy.tools.GroovyClass;
import org.webpieces.templating.api.CompileCallback;
import org.webpieces.templating.api.HtmlTagLookup;
import org.webpieces.templating.api.Template;
import org.webpieces.templating.api.TemplateCompileConfig;
import org.webpieces.templating.api.TemplateService;
import org.webpieces.templating.impl.HtmlToJavaClassCompiler;
import org.webpieces.templating.impl.ProdTemplateService;
import org.webpieces.templating.impl.TemplateImpl;
import org.webpieces.templating.impl.source.ScriptOutputImpl;
import org.webpieces.util.file.VirtualFile;
import org.webpieces.util.file.VirtualFileClasspath;

public class DevTemplateService
extends ProdTemplateService
implements TemplateService {
    private HtmlToJavaClassCompiler compiler;
    private TemplateCompileConfig config;
    private HtmlTagLookup htmlTagLookup;

    @Inject
    public DevTemplateService(HtmlTagLookup htmlTagLookup, HtmlToJavaClassCompiler compiler, TemplateCompileConfig config) {
        super(htmlTagLookup);
        this.htmlTagLookup = htmlTagLookup;
        this.compiler = compiler;
        this.config = config;
    }

    protected Template loadTemplate(String fullTemplatePath, String fullClassName) {
        try {
            return this.loadTemplateImpl(fullTemplatePath, fullClassName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private Template loadTemplateImpl(String fullTemplatePath, String templateFullClassName) throws IOException, ClassNotFoundException {
        VirtualFileClasspath theResource = null;
        List<VirtualFile> srcPaths = this.config.getSrcPaths();
        for (VirtualFile f : srcPaths) {
            VirtualFile child = f.child(fullTemplatePath.substring(1));
            if (!child.exists()) continue;
            theResource = child;
            break;
        }
        if (theResource == null) {
            theResource = new VirtualFileClasspath(fullTemplatePath, DevTemplateService.class);
        }
        if (!theResource.exists()) {
            throw new FileNotFoundException("resource=" + fullTemplatePath + " was not found in classpath");
        }
        try (InputStream resource = theResource.openInputStream();){
            String viewSource = IOUtils.toString((InputStream)resource, (String)this.config.getFileEncoding().name());
            Class<?> compiledTemplate = this.createTemplate(templateFullClassName, viewSource);
            TemplateImpl templateImpl = new TemplateImpl(this.htmlTagLookup, compiledTemplate);
            return templateImpl;
        }
    }

    private Class<?> createTemplate(String fullClassName, String source) throws ClassNotFoundException {
        GroovyClassLoader cl = new GroovyClassLoader();
        ScriptOutputImpl scriptCode = this.compiler.compile(fullClassName, source, new DevTemplateCompileCallback(cl));
        return cl.loadClass(scriptCode.getFullClassName());
    }

    private static class DevTemplateCompileCallback
    implements CompileCallback {
        private GroovyClassLoader cl;

        public DevTemplateCompileCallback(GroovyClassLoader cl) {
            this.cl = cl;
        }

        @Override
        public void compiledGroovyClass(GroovyClass groovyClass) {
            this.cl.defineClass(groovyClass.getName(), groovyClass.getBytes());
        }

        @Override
        public void routeIdFound(String routeId, List<String> argNames, String sourceLocation) {
        }
    }
}

