/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.templating.impl.source;

import java.util.Stack;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.webpieces.templating.api.AbstractTag;
import org.webpieces.templating.api.CompileCallback;
import org.webpieces.templating.api.GroovyGen;
import org.webpieces.templating.api.HtmlTag;
import org.webpieces.templating.api.HtmlTagLookup;
import org.webpieces.templating.api.TemplateCompileConfig;
import org.webpieces.templating.impl.source.GenLookup;
import org.webpieces.templating.impl.source.ScriptOutputImpl;
import org.webpieces.templating.impl.source.TagState;
import org.webpieces.templating.impl.source.TokenImpl;
import org.webpieces.templating.impl.source.UniqueIdGenerator;
import org.webpieces.templating.impl.tags.ParseTagArgs;
import org.webpieces.templating.impl.tags.TagGen;

public class ScriptWriter {
    protected static final int maxLineLength = 30000;
    private Pattern pattern = Pattern.compile("\"");
    private ThreadLocal<Stack<TagState>> tagStack = new ThreadLocal();
    private GenLookup generatorLookup;
    private HtmlTagLookup htmlTagLookup;
    private UniqueIdGenerator uniqueIdGen;
    private TemplateCompileConfig config;

    @Inject
    public ScriptWriter(HtmlTagLookup htmlTagLookup, GenLookup lookup, UniqueIdGenerator generator, TemplateCompileConfig config) {
        this.htmlTagLookup = htmlTagLookup;
        this.generatorLookup = lookup;
        this.uniqueIdGen = generator;
        this.config = config;
    }

    public void printHead(ScriptOutputImpl sourceCode, String packageStr, String className) {
        this.tagStack.set(new Stack());
        if (packageStr != null && !"".equals(packageStr.trim())) {
            sourceCode.println("package " + packageStr, null);
            sourceCode.println();
        }
        sourceCode.println("import org.webpieces.ctx.api.Current", null);
        sourceCode.println();
        sourceCode.print("class ");
        sourceCode.print(className);
        sourceCode.println(" extends org.webpieces.templating.impl.GroovyTemplateSuperclass {", null);
        sourceCode.println("  public Object run() {", null);
        sourceCode.println("    use(org.webpieces.templating.impl.source.GroovyExtensions) {", null);
    }

    public void printEnd(ScriptOutputImpl sourceCode) {
        sourceCode.println("    }", null);
        sourceCode.println("  }", null);
        sourceCode.println("}", null);
        if (this.tagStack.get().size() > 0) {
            TagState state = this.tagStack.get().pop();
            TokenImpl token = state.getToken();
            throw new IllegalStateException("Found unmatched tag #{" + token.getCleanValue() + "}#. " + token.getSourceLocation(true));
        }
    }

    public void printPlain(TokenImpl token, ScriptOutputImpl sourceCode) {
        String srcText = token.getValue();
        if (srcText.length() < 30000) {
            String text = this.addEscapesToSrc(srcText);
            sourceCode.println("      __out.print(\"" + text + "\");", token);
            return;
        }
        while (srcText.length() > 0) {
            int cutpoint = Math.min(srcText.length(), 30000);
            String prefix = srcText.substring(0, cutpoint);
            srcText = srcText.substring(cutpoint);
            String text = this.addEscapesToSrc(prefix);
            sourceCode.println("       __out.print(\"" + text + "\");", token);
        }
    }

    private String addEscapesToSrc(String srcText) {
        String text = srcText.replace("\\", "\\\\");
        text = this.pattern.matcher(text).replaceAll("\\\\\"");
        text = text.replace("\n", "\\n");
        text = text.replace("$", "\\$");
        return text;
    }

    public void printScript(TokenImpl token, ScriptOutputImpl sourceCode) {
        sourceCode.println(token.getValue().trim(), token);
    }

    public void printExpression(TokenImpl token, ScriptOutputImpl sourceCode) {
        String expr = token.getCleanValue();
        sourceCode.println();
        sourceCode.println("       enterExpression('" + token.getSourceLocation(false) + "');", token);
        if (expr.startsWith("_")) {
            sourceCode.println("       __out.print(" + expr + ");", token);
        } else {
            sourceCode.println("       __out.print(useFormatter(" + expr + "));", token);
        }
        sourceCode.println("       exitExpression();", token);
        sourceCode.println();
    }

    public void printMessage(TokenImpl token, ScriptOutputImpl sourceCode) {
        String value = token.getValue().replaceAll("\r", "");
        String withValidNewLines = this.replaceNewLinesBetweenQuotes(value, token);
        withValidNewLines = withValidNewLines.replace("\n", " ");
        sourceCode.println();
        sourceCode.println("       enterExpression('" + token.getSourceLocation(false) + "');", token);
        sourceCode.println("       __out.print(getMessage(" + withValidNewLines + "));", token);
        sourceCode.println("       exitExpression();", token);
        sourceCode.println();
    }

    private String replaceNewLinesBetweenQuotes(String value, TokenImpl token) {
        int currentIndex = 0;
        int indexOf;
        while ((indexOf = value.indexOf("'", currentIndex)) >= 0) {
            int secondQuote = value.indexOf("'", indexOf + 1);
            if (secondQuote < 0) {
                throw new IllegalArgumentException("unbalanced quote in &{...}&. " + token.getSourceLocation(true));
            }
            String before = value.substring(0, indexOf);
            String middle = value.substring(indexOf, secondQuote + 1);
            middle = middle.replaceAll("\n", "\\\\n");
            String after = value.substring(secondQuote + 1);
            String firstPartWithQuotes = before + middle;
            currentIndex = firstPartWithQuotes.length();
            value = firstPartWithQuotes + after;
        }
        return value;
    }

    public void printAction(TokenImpl token, ScriptOutputImpl sourceCode, boolean isAbsolute, CompileCallback callbacks) {
        if (isAbsolute) {
            throw new UnsupportedOperationException("not supported yet.  Need to modify to use the Host header as input as the domain");
        }
        String expr = token.getCleanValue();
        String groovySnippet = ParseTagArgs.translateRouteId(expr, token, callbacks);
        sourceCode.println("       __out.print(" + groovySnippet + ");", token);
    }

    public void printStartEndTag(TokenImpl token, ScriptOutputImpl sourceCode, CompileCallback callbacks) {
        String expr = token.getCleanValue();
        int indexOfSpace = expr.indexOf(" ");
        String tagName = expr;
        if (indexOfSpace > 0) {
            tagName = expr.substring(0, indexOfSpace);
        }
        int id = this.uniqueIdGen.generateId();
        GroovyGen generator = this.generatorLookup.lookup(tagName, token);
        HtmlTag htmltag = this.htmlTagLookup.lookup(tagName);
        if (generator != null) {
            generator.generateStartAndEnd(sourceCode, token, id, callbacks);
        } else {
            if (htmltag == null) {
                throw new IllegalArgumentException("Unknown tag=" + tagName + " location=" + token.getSourceLocation(true));
            }
            new TagGen(tagName, token).generateStartAndEnd(sourceCode, token, id, callbacks);
        }
    }

    public void printStartTag(TokenImpl token, TokenImpl previousToken, ScriptOutputImpl sourceCode, CompileCallback callbacks) {
        String tagName = token.getTagName();
        GroovyGen generator = this.generatorLookup.lookup(tagName, token);
        HtmlTag htmltag = this.htmlTagLookup.lookup(tagName);
        if (generator != null) {
            if (generator instanceof AbstractTag) {
                AbstractTag abstractTag = (AbstractTag)generator;
                abstractTag.validatePreviousSibling(token, previousToken);
            }
        } else {
            if (htmltag == null && !this.config.getCustomTagsFromPlugin().contains(tagName)) {
                throw new IllegalArgumentException("Unknown tag=#{" + tagName + "}# OR you didn't add '" + tagName + "' to list of customTags in build.gradle file. " + token.getSourceLocation(true));
            }
            generator = new TagGen(tagName, token);
        }
        int id = this.uniqueIdGen.generateId();
        generator.generateStart(sourceCode, token, id, callbacks);
        this.tagStack.get().push(new TagState(token, generator, id));
    }

    public void printEndTag(TokenImpl token, ScriptOutputImpl sourceCode) {
        String expr = token.getCleanValue();
        if (this.tagStack.get().size() == 0) {
            throw new IllegalArgumentException("Unmatched end tag #{/" + expr + "}# as the begin tag was not found..only the end tag. location=" + token.getSourceLocation(true));
        }
        TagState currentState = this.tagStack.get().pop();
        TokenImpl currentToken = currentState.getToken();
        if (!expr.equals(currentToken.getTagName())) {
            throw new IllegalArgumentException("Unmatched end tag #{/" + expr + "}# as the begin tag appears to be #{" + currentToken.getCleanValue() + "}# which does not match.  end tag location=" + token.getSourceLocation(false) + " begin tag location=" + currentToken.getSourceLocation(false));
        }
        GroovyGen generator = currentState.getGenerator();
        int uniqueId = currentState.getUniqueId();
        generator.generateEnd(sourceCode, token, uniqueId);
    }

    public void unprintUpToLastNewLine() {
    }

    public void cleanup() {
        this.tagStack.set(null);
    }
}

