/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.templating.impl.source;

import org.webpieces.templating.api.Token;
import org.webpieces.templating.impl.GroovyTemplateSuperclass;
import org.webpieces.templating.impl.source.TemplateToken;

public class TokenImpl
implements Token {
    public int begin;
    public int end;
    public TemplateToken state;
    public int beginLineNumber;
    public int endLineNumber;
    public String source;
    private String filePath;

    public TokenImpl(String filePath, int begin, int end, TemplateToken state, int beginLineNumber, int endLineNumber, String source) {
        this.filePath = filePath;
        this.begin = begin;
        this.end = end;
        this.state = state;
        this.beginLineNumber = beginLineNumber;
        this.endLineNumber = endLineNumber;
        this.source = source;
    }

    public String toString() {
        return "Token [state=" + (Object)((Object)this.state) + ", beginLineNumber=" + this.beginLineNumber + ", endLineNumber=" + this.endLineNumber + ", begin=" + this.begin + ", end=" + this.end + ", snippet='" + this.getValue() + "']";
    }

    public String getValue() {
        String value = this.source.substring(this.begin, this.end);
        return value;
    }

    @Override
    public String getCleanValue() {
        return this.getValue().replaceAll("\r", "").replaceAll("\n", " ").trim();
    }

    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public String getSourceLocation(boolean dueToError) {
        String fileName = this.filePath;
        int lastIndexOf = this.filePath.lastIndexOf("/");
        if (lastIndexOf > 0) {
            fileName = this.filePath.substring(lastIndexOf + 1);
        }
        String filePathAsClassName = this.filePath.replace("/", ".");
        String loc = "at " + filePathAsClassName + "(" + fileName + ":" + this.beginLineNumber + ")";
        if (!dueToError) {
            return loc;
        }
        return GroovyTemplateSuperclass.modifySourceLocation2((String)loc);
    }

    @Override
    public boolean isEndTag() {
        return this.state == TemplateToken.END_TAG;
    }

    public String getTagName() {
        String expr = this.getCleanValue();
        int indexOfSpace = expr.indexOf(" ");
        String tagName = expr;
        if (indexOfSpace > 0) {
            tagName = expr.substring(0, indexOfSpace);
        }
        return tagName;
    }
}

