/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.templating.impl.tags;

import java.util.ArrayList;
import java.util.List;
import org.webpieces.templating.api.CompileCallback;
import org.webpieces.templating.api.GroovyGen;
import org.webpieces.templating.api.ScriptOutput;
import org.webpieces.templating.api.Token;

public abstract class ParseTagArgs
implements GroovyGen {
    protected void generateStartAttrs(ScriptOutput sourceCode, Token token, int uniqueId, CompileCallback callback) {
        String tagArgs = this.fetchArgs(token, callback);
        sourceCode.println("enterExpression('" + token.getSourceLocation(false) + "');", token);
        sourceCode.println("_attrs" + uniqueId + " = [" + tagArgs + "];", token);
        sourceCode.println("exitExpression();", token);
        sourceCode.println();
    }

    private String fetchArgs(Token token, CompileCallback callback) {
        String tagArgs;
        String expr = token.getCleanValue();
        int indexOfSpace = expr.indexOf(" ");
        if (indexOfSpace > 0) {
            tagArgs = expr.substring(indexOfSpace + 1).trim();
            if (!tagArgs.matches("^[_a-zA-Z0-9]+\\s*:.*$")) {
                tagArgs = "defaultArgument:" + tagArgs;
            }
            while (tagArgs.contains("@[")) {
                tagArgs = ParseTagArgs.replaceRouteIds(token, tagArgs, indexOfSpace, callback);
            }
        } else {
            tagArgs = ":";
        }
        return tagArgs;
    }

    public static String replaceRouteIds(Token token, String tagArgs, int indexOfSpace, CompileCallback callback) {
        int atIndex = tagArgs.indexOf("@[");
        int nextAtIndex = tagArgs.indexOf("]@");
        if (nextAtIndex < 0) {
            throw new IllegalArgumentException("Missing closing ]@ on the route." + token.getSourceLocation(true));
        }
        String prefix = tagArgs.substring(0, atIndex);
        String routeInfo = tagArgs.substring(atIndex + 2, nextAtIndex);
        String leftover = tagArgs.substring(nextAtIndex + 2);
        String groovyCode = ParseTagArgs.translateRouteId(routeInfo, token, callback);
        String groovy = prefix + groovyCode + leftover;
        return groovy;
    }

    public static String translateRouteId(String routeText, Token token, CompileCallback callback) {
        String args;
        String route;
        int firstCommaLocation = routeText.indexOf(",");
        if (firstCommaLocation > 0) {
            route = routeText.substring(0, firstCommaLocation);
            args = routeText.substring(firstCommaLocation + 1);
            args = "[" + args + "]";
        } else {
            route = routeText;
            args = "[:]";
        }
        List<String> argNames = ParseTagArgs.fetchArgNames(args, token);
        callback.routeIdFound(route, argNames, token.getSourceLocation(false));
        return "fetchUrl('" + route + "', " + args + ", '" + token.getSourceLocation(false) + "')";
    }

    private static List<String> fetchArgNames(String args, Token token) {
        ArrayList<String> names = new ArrayList<String>();
        if ("[:]".equals(args)) {
            return names;
        }
        String noBracketsArgs = args.substring(1, args.length() - 1);
        String[] split = noBracketsArgs.split("[:,]");
        if (split.length % 2 != 0) {
            throw new IllegalArgumentException("The groovy Map appears to be invalid as splitting on [:,] results in an odd amount of elements and it shold be key:value,key2:value " + token.getSourceLocation(true));
        }
        for (int i = 0; i < split.length; i += 2) {
            names.add(split[i]);
        }
        return names;
    }
}

