/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.templatingdev.impl;

import com.webpieces.util.compiling.GroovyCompiling;
import groovy.lang.GroovyClassLoader;
import javax.inject.Inject;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.tools.GroovyClass;
import org.webpieces.templatingdev.api.CompileCallback;
import org.webpieces.templatingdev.impl.source.ScriptOutputImpl;
import org.webpieces.util.exceptions.SneakyThrow;

public class GroovyToJavaClassCompiler {
    private CompileCallback callbacks;

    @Inject
    public GroovyToJavaClassCompiler(CompileCallback callbacks) {
        this.callbacks = callbacks;
    }

    public void compile(GroovyClassLoader cl, ScriptOutputImpl scriptCode) {
        try {
            this.compileImpl(cl, scriptCode);
        }
        catch (SecurityException e) {
            throw SneakyThrow.sneak((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileImpl(GroovyClassLoader groovyCl, ScriptOutputImpl scriptCode) {
        try {
            GroovyCompiling.setCompilingGroovy((boolean)true);
            CompilationUnit compileUnit = new CompilationUnit();
            compileUnit.addSource(scriptCode.getFullClassName(), scriptCode.getScriptSourceCode());
            compileUnit.compile(7);
            compileUnit.setClassLoader(groovyCl);
            for (Object compileClass : compileUnit.getClasses()) {
                GroovyClass groovyClass = (GroovyClass)compileClass;
                this.callbacks.compiledGroovyClass(groovyCl, groovyClass);
            }
        }
        finally {
            GroovyCompiling.setCompilingGroovy((boolean)false);
        }
    }
}

