/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.templating.api;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webpieces.templating.api.ConverterLookup;
import org.webpieces.templating.api.HtmlTag;
import org.webpieces.templating.api.RouterLookup;
import org.webpieces.templating.api.TemplateConfig;
import org.webpieces.templating.api.TemplateService;
import org.webpieces.templating.impl.tags.BootstrapModalTag;
import org.webpieces.templating.impl.tags.ExtendsTag;
import org.webpieces.templating.impl.tags.FieldTag;
import org.webpieces.templating.impl.tags.FormTag;
import org.webpieces.templating.impl.tags.HtmlGetTag;
import org.webpieces.templating.impl.tags.HtmlSetTag;
import org.webpieces.templating.impl.tags.JsActionTag;
import org.webpieces.templating.impl.tags.OptionTag;
import org.webpieces.templating.impl.tags.RenderPageArgsTag;
import org.webpieces.templating.impl.tags.RenderTagArgsTag;
import org.webpieces.templating.impl.tags.ScriptTag;
import org.webpieces.templating.impl.tags.StyleSheetTag;
import org.webpieces.templating.impl.tags.TemplateLoaderTag;

public class HtmlTagLookup {
    private static final Logger log = LoggerFactory.getLogger(HtmlTagLookup.class);
    private Map<String, HtmlTag> tags = new HashMap<String, HtmlTag>();
    protected ConverterLookup converter;

    @Inject
    public HtmlTagLookup(TemplateConfig config, RouterLookup lookup, ConverterLookup converter) {
        this.converter = converter;
        this.put(new OptionTag(converter));
        this.put(new HtmlSetTag());
        this.put(new HtmlGetTag());
        this.put(new ExtendsTag());
        this.put(new FormTag(config.getDefaultFormAcceptEncoding()));
        this.put(new RenderTagArgsTag());
        this.put(new RenderPageArgsTag());
        this.put(new JsActionTag());
        this.put(new StyleSheetTag(lookup));
        this.put(new ScriptTag(lookup));
        this.put(new BootstrapModalTag());
        this.put(new FieldTag(converter, "/org/webpieces/templating/impl/field.tag"));
    }

    protected void put(HtmlTag tag) {
        HtmlTag htmlTag = this.tags.get(tag.getName());
        if (htmlTag != null) {
            log.warn("You are overriding Tag=" + tag.getName() + " from class=" + htmlTag.getClass() + " to your class=" + tag.getClass());
        } else {
            log.info("adding tag=" + tag.getName());
        }
        this.tags.put(tag.getName(), tag);
    }

    public HtmlTag lookup(String tagName) {
        HtmlTag tag = this.tags.get(tagName);
        return tag;
    }

    public void initialize(TemplateService templateService) {
        for (HtmlTag tag : this.tags.values()) {
            if (!(tag instanceof TemplateLoaderTag)) continue;
            TemplateLoaderTag fileTag = (TemplateLoaderTag)tag;
            fileTag.initialize(templateService);
        }
    }
}

