/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.templating.impl.html;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class HTML {
    private static final HtmlCharacterEntityReferences characterEntityReferences = new HtmlCharacterEntityReferences();

    public static String htmlEscape(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder escaped = new StringBuilder(input.length() * 2);
        for (int i = 0; i < input.length(); ++i) {
            char character = input.charAt(i);
            String reference = characterEntityReferences.convertToReference(character);
            if (reference != null) {
                escaped.append(reference);
                continue;
            }
            escaped.append(character);
        }
        return escaped.toString();
    }

    public static class HtmlCharacterEntityReferences {
        static final char REFERENCE_START = '&';
        static final String DECIMAL_REFERENCE_START = "&#";
        static final String HEX_REFERENCE_START = "&#x";
        static final char REFERENCE_END = ';';
        static final char CHAR_NULL = '\uffff';
        private static final String PROPERTIES_FILE = "/htmlentities.properties";
        private final String[] characterToEntityReferenceMap = new String[3000];
        private final Map<String, Character> entityReferenceToCharacterMap = new HashMap<String, Character>(252);

        public HtmlCharacterEntityReferences() {
            Properties entityReferences = new Properties();
            InputStream is = HtmlCharacterEntityReferences.class.getResourceAsStream(PROPERTIES_FILE);
            if (is == null) {
                throw new IllegalStateException("Cannot find reference definition file [/htmlentities.properties] as class path resource");
            }
            try {
                try {
                    entityReferences.load(is);
                }
                finally {
                    is.close();
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException("Failed to parse reference definition file [HtmlCharacterEntityReferences.properties]: " + ex.getMessage());
            }
            Enumeration<?> keys = entityReferences.propertyNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                int referredChar = Integer.parseInt(key);
                int index = referredChar < 1000 ? referredChar : referredChar - 7000;
                String reference = entityReferences.getProperty(key);
                this.characterToEntityReferenceMap[index] = '&' + reference + ';';
                this.entityReferenceToCharacterMap.put(reference, new Character((char)referredChar));
            }
        }

        public int getSupportedReferenceCount() {
            return this.entityReferenceToCharacterMap.size();
        }

        public boolean isMappedToReference(char character) {
            return this.convertToReference(character) != null;
        }

        public String convertToReference(char character) {
            int index;
            String entityReference;
            if ((character < 1000 || character >= 8000 && character < 10000) && (entityReference = this.characterToEntityReferenceMap[index = character < 1000 ? character : character - 7000]) != null) {
                return entityReference;
            }
            return null;
        }

        public char convertToCharacter(String entityReference) {
            Character referredCharacter = this.entityReferenceToCharacterMap.get(entityReference);
            if (referredCharacter != null) {
                return referredCharacter.charValue();
            }
            return '\uffff';
        }
    }
}

