/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.templating.impl.tags;

import com.google.common.collect.Sets;
import groovy.lang.Closure;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import org.webpieces.templating.api.HtmlTag;
import org.webpieces.templating.impl.GroovyTemplateSuperclass;
import org.webpieces.util.net.URLEncoder;

public class BootstrapModalTag
implements HtmlTag {
    private Set<String> excludes = Sets.newHashSet((Object[])new String[]{"route", "modalId", "linkId"});
    public static final int AJAX_REDIRECT_CODE = 287;

    @Override
    public void runTag(Map<Object, Object> args, Closure<?> body, PrintWriter out, GroovyTemplateSuperclass template, String srcLocation) {
        Object route = args.get("route");
        Object modalId = args.get("modalId");
        Object linkId = args.get("linkId");
        if (route == null) {
            throw new IllegalArgumentException("#{bootstrapModal/}# tag must contain a route argument like #{bootstrapModal route:@[AJAX_EDIT_USER_FORM, id:'{id}']@}#. " + srcLocation);
        }
        if (modalId == null) {
            throw new IllegalArgumentException("#{bootstrapModal/}# tag must contain a modalId argument like #{bootstrapModal modalId:'addEditModal'}#. " + srcLocation);
        }
        if (linkId == null) {
            throw new IllegalArgumentException("#{bootstrapModal/}# tag must contain a linkId argument like #{bootstrapModal linkId:'edit_'+entity.id}#. " + srcLocation);
        }
        if (body != null) {
            throw new IllegalArgumentException("Only #{bootstrapModal/}# can be used.  You cannot do #{bootstrapModal}# #{/bootstrapModal} as the body is not used with this tag" + srcLocation);
        }
        String urlPath = this.fillInUrlParams(route + "", args);
        this.printXX(out, "<script type=`text/javascript`>");
        this.println(out, "  $(document).ready(function() {");
        this.printXX(out, "         $(`#" + linkId + "`).click(function(e){");
        this.println(out, "             $('#" + modalId + "').load('" + urlPath + "', function(response, status, xhr){");
        this.println(out, "                 if (xhr.status == 287) {");
        this.println(out, "                     window.location = xhr.getResponseHeader('Location')");
        this.println(out, "                 } else if (xhr.status != 200) {");
        this.println(out, "                     alert('Cannot connect to server.  Check your network connection')");
        this.println(out, "                 } else {");
        this.printXX(out, "                     $(`#" + modalId + "`).modal('show');");
        this.println(out, "                 }");
        this.println(out, "              });");
        this.println(out, "         });");
        this.println(out, "   });");
        this.println(out, "</script>");
    }

    private String fillInUrlParams(String route, Map<Object, Object> args) {
        String modifiedRoute = URLEncoder.decode((String)route, (Charset)StandardCharsets.UTF_8);
        for (Map.Entry<Object, Object> entry : args.entrySet()) {
            String key = entry.getKey() + "";
            if (this.excludes.contains(key)) continue;
            String value = entry.getValue() + "";
            String encodedValue = URLEncoder.encode((String)value, (Charset)StandardCharsets.UTF_8);
            modifiedRoute = modifiedRoute.replace("{" + key + "}", encodedValue);
        }
        return modifiedRoute;
    }

    private void println(PrintWriter out, String string) {
        out.println(string);
    }

    private void printXX(PrintWriter out, String string) {
        out.println(string.replace("`", "\""));
    }

    @Override
    public String getName() {
        return "bootstrapModal";
    }
}

