/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.templating.impl.tags;

import groovy.lang.Closure;
import java.io.PrintWriter;
import java.util.Map;
import org.webpieces.templating.api.HtmlTag;
import org.webpieces.templating.api.RouterLookup;
import org.webpieces.templating.api.TemplateUtil;
import org.webpieces.templating.impl.GroovyTemplateSuperclass;

public class StyleSheetTag
implements HtmlTag {
    private RouterLookup lookup;

    public StyleSheetTag(RouterLookup lookup) {
        this.lookup = lookup;
    }

    @Override
    public void runTag(Map<Object, Object> args, Closure<?> body, PrintWriter out, GroovyTemplateSuperclass template, String srcLocation) {
        String hash;
        Object maybeType;
        Object url = args.get("href");
        if (url == null) {
            throw new IllegalArgumentException("#{stylesheet/}# tag must contain an href argument name like #{stylesheet href:'/assets/crud/css/theme.css'}#. " + srcLocation);
        }
        if (body != null) {
            throw new IllegalArgumentException("Only #{stylesheet/}# can be used.  You cannot do #{stylesheet}# #{/stylesheet} as the body is not used with this tag" + srcLocation);
        }
        String rel = "stylesheet";
        String type = "text/css";
        Object maybeRel = args.get("rel");
        if (maybeRel != null) {
            rel = maybeRel + "";
        }
        if ((maybeType = args.get("type")) != null) {
            type = maybeType + "";
        }
        if ((hash = this.lookup.pathToUrlEncodedHash(url + "")) != null) {
            url = url + "?hash=" + hash;
        }
        out.println("<link rel=\"" + rel + "\" type=\"" + type + "\" href=\"" + url + "\" " + TemplateUtil.serialize(args, "href") + "/>");
    }

    @Override
    public String getName() {
        return "stylesheet";
    }
}

