/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.webserver.test;

import com.google.inject.Module;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLEngine;
import org.webpieces.httpclient11.api.HttpClient;
import org.webpieces.httpclient11.api.HttpClientFactory;
import org.webpieces.httpclient11.api.HttpSocket;
import org.webpieces.httpclient11.api.HttpSocketListener;
import org.webpieces.mock.time.MockTime;
import org.webpieces.mock.time.MockTimer;
import org.webpieces.nio.api.BackpressureConfig;
import org.webpieces.util.exceptions.SneakyThrow;
import org.webpieces.webserver.test.MockChannelManager;
import org.webpieces.webserver.test.NullHttp1CloseListener;
import org.webpieces.webserver.test.OverridesForEmbeddedSvrWithParsing;
import org.webpieces.webserver.test.OverridesForTestRealServer;
import org.webpieces.webserver.test.http11.DirectHttp11Client;

public class AbstractWebpiecesTest {
    protected MockChannelManager mgr = new MockChannelManager();
    protected MockTime time = new MockTime(true);
    protected MockTimer mockTimer = new MockTimer();

    @Deprecated
    public HttpSocket connectHttp(boolean isRemote, InetSocketAddress addr) throws InterruptedException, ExecutionException, TimeoutException {
        NullHttp1CloseListener listener = new NullHttp1CloseListener();
        HttpSocket socket = this.getClient(isRemote).createHttpSocket((HttpSocketListener)listener);
        CompletableFuture connect = socket.connect(addr);
        connect.get(2L, TimeUnit.SECONDS);
        return socket;
    }

    public HttpSocket connectHttp(InetSocketAddress addr) {
        return this.connectHttp(addr, null);
    }

    public HttpSocket connectHttp(InetSocketAddress addr, HttpSocketListener listener) {
        if (listener == null) {
            listener = new NullHttp1CloseListener();
        }
        HttpSocket socket = this.getClient().createHttpSocket(listener);
        CompletableFuture connect = socket.connect(addr);
        try {
            connect.get(2L, TimeUnit.SECONDS);
            return socket;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw SneakyThrow.sneak((Throwable)e);
        }
    }

    @Deprecated
    public HttpSocket connectHttps(boolean isRemote, SSLEngine engine, InetSocketAddress addr) throws InterruptedException, ExecutionException, TimeoutException {
        NullHttp1CloseListener listener = new NullHttp1CloseListener();
        HttpSocket socket = this.getClient(isRemote).createHttpsSocket(engine, (HttpSocketListener)listener);
        CompletableFuture connect = socket.connect(addr);
        connect.get(2L, TimeUnit.SECONDS);
        return socket;
    }

    public HttpSocket connectHttps(SSLEngine engine, InetSocketAddress addr) {
        return this.connectHttps(engine, addr, null);
    }

    public HttpSocket connectHttps(SSLEngine engine, InetSocketAddress addr, HttpSocketListener listener) {
        if (listener == null) {
            listener = new NullHttp1CloseListener();
        }
        HttpSocket socket = this.getClient().createHttpsSocket(engine, listener);
        CompletableFuture connect = socket.connect(addr);
        try {
            connect.get(2L, TimeUnit.SECONDS);
            return socket;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw SneakyThrow.sneak((Throwable)e);
        }
    }

    @Deprecated
    protected Module getOverrides(boolean isFullServer, MeterRegistry metrics) {
        if (isFullServer) {
            return new OverridesForTestRealServer(metrics);
        }
        return new OverridesForEmbeddedSvrWithParsing(this.mgr, this.time, this.mockTimer, metrics);
    }

    protected Module getOverrides(MeterRegistry metrics) {
        if (this.isRemote()) {
            return new OverridesForTestRealServer(metrics);
        }
        return new OverridesForEmbeddedSvrWithParsing(this.mgr, this.time, this.mockTimer, metrics);
    }

    @Deprecated
    protected HttpClient getClient(boolean isRemote) {
        if (isRemote) {
            HttpClient client = HttpClientFactory.createHttpClient((String)"testClient", (int)5, (BackpressureConfig)new BackpressureConfig(), (MeterRegistry)Metrics.globalRegistry);
            return client;
        }
        return new DirectHttp11Client(this.mgr);
    }

    protected HttpClient getClient() {
        if (this.isRemote()) {
            HttpClient client = HttpClientFactory.createHttpClient((String)"testClient", (int)5, (BackpressureConfig)new BackpressureConfig(), (MeterRegistry)Metrics.globalRegistry);
            return client;
        }
        return new DirectHttp11Client(this.mgr);
    }

    protected boolean isRemote() {
        return false;
    }
}

