/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.webserver.test;

import java.util.concurrent.CompletableFuture;
import javax.net.ssl.SSLEngine;
import org.webpieces.nio.api.ChannelManager;
import org.webpieces.nio.api.SSLEngineFactory;
import org.webpieces.nio.api.channels.Channel;
import org.webpieces.nio.api.channels.DatagramChannel;
import org.webpieces.nio.api.channels.TCPChannel;
import org.webpieces.nio.api.channels.TCPServerChannel;
import org.webpieces.nio.api.channels.UDPChannel;
import org.webpieces.nio.api.handlers.ConnectionListener;
import org.webpieces.nio.api.handlers.DataListener;
import org.webpieces.nio.api.handlers.DatagramListener;
import org.webpieces.webserver.test.MockServerChannel;

public class MockChannelManager
implements ChannelManager {
    private ConnectionListener httpConnectionListener;
    private ConnectionListener httpsConnectionListener;
    private ConnectionListener backendConnectionListener;

    public TCPServerChannel createTCPServerChannel(String id, ConnectionListener connectionListener) {
        if (id.startsWith("backend")) {
            this.backendConnectionListener = connectionListener;
            return new MockServerChannel();
        }
        this.httpConnectionListener = connectionListener;
        return new MockServerChannel();
    }

    public TCPServerChannel createTCPServerChannel(String id, ConnectionListener connectionListener, SSLEngineFactory factory) {
        if (id.startsWith("backend")) {
            this.backendConnectionListener = connectionListener;
            return new MockServerChannel();
        }
        this.httpsConnectionListener = connectionListener;
        return new MockServerChannel();
    }

    public CompletableFuture<DataListener> simulateHttpsConnect(Channel channel) {
        return this.httpsConnectionListener.connected(channel, true);
    }

    public CompletableFuture<DataListener> simulateHttpConnect(Channel channel) {
        return this.httpConnectionListener.connected(channel, true);
    }

    public TCPChannel createTCPChannel(String id) {
        return null;
    }

    public TCPChannel createTCPChannel(String id, SSLEngine engine) {
        return null;
    }

    public UDPChannel createUDPChannel(String id) {
        return null;
    }

    public DatagramChannel createDatagramChannel(String id, int bufferSize, DatagramListener listener) {
        return null;
    }

    public void stop() {
    }

    public ConnectionListener getHttpConnection() {
        return this.httpConnectionListener;
    }

    public ConnectionListener getHttpsConnection() {
        return this.httpsConnectionListener;
    }

    public ConnectionListener getBackendConnection() {
        return this.backendConnectionListener;
    }

    public String getName() {
        return "mockChanMgr2";
    }

    public TCPServerChannel createTCPUpgradableChannel(String id, ConnectionListener connectionListener, SSLEngineFactory factory) {
        throw new UnsupportedOperationException("not implemented but could easily be with a one liner");
    }
}

