/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.webserver.test;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webpieces.mock.time.MockTime;
import org.webpieces.mock.time.MockTimer;
import org.webpieces.nio.api.ChannelManager;
import org.webpieces.templatingdev.api.DevTemplateModule;
import org.webpieces.templatingdev.api.TemplateCompileConfig;
import org.webpieces.util.threading.DirectExecutorService;
import org.webpieces.util.time.Time;
import org.webpieces.webserver.test.MockChannelManager;

public class OverridesForEmbeddedSvrWithParsing
implements Module {
    private static final Logger log = LoggerFactory.getLogger(OverridesForEmbeddedSvrWithParsing.class);
    private TemplateCompileConfig templateConfig;
    private MockChannelManager mgr;
    private MockTime time;
    private MockTimer mockTimer;
    private MeterRegistry metrics;

    public OverridesForEmbeddedSvrWithParsing(MockChannelManager mgr, MockTime time, MockTimer mockTimer, MeterRegistry metrics) {
        this(mgr, time, mockTimer, new TemplateCompileConfig(OverridesForEmbeddedSvrWithParsing.isGradleRunning()), metrics);
    }

    public OverridesForEmbeddedSvrWithParsing(MockChannelManager mgr, MockTime time, MockTimer mockTimer, TemplateCompileConfig config, MeterRegistry metrics) {
        this.mgr = mgr;
        this.time = time;
        this.mockTimer = mockTimer;
        this.templateConfig = config;
        this.metrics = metrics;
    }

    public void configure(Binder binder) {
        binder.bind(MeterRegistry.class).toInstance((Object)this.metrics);
        binder.bind(ChannelManager.class).toInstance((Object)this.mgr);
        binder.bind(Time.class).toInstance((Object)this.time);
        binder.bind(ScheduledExecutorService.class).toInstance((Object)this.mockTimer);
        binder.install((Module)new DevTemplateModule(this.templateConfig));
    }

    @Provides
    @Singleton
    @Named(value="fileReadExecutor")
    public ExecutorService provideExecutor() {
        return new DirectExecutorService();
    }

    public static boolean isGradleRunning() {
        String property = System.getProperty("gradle.running");
        if ("true".equals(property)) {
            log.info("gradle running.  using class files from filesystem");
            return true;
        }
        log.info("gradle NOT running.  generating groovy class files for test so test doesn't fail with class not found in IDE ever");
        return false;
    }
}

