/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.webserver.test;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.webpieces.httpclient11.api.HttpFullRequest;
import org.webpieces.httpclient11.api.HttpSocket;
import org.webpieces.httpparser.api.common.Header;
import org.webpieces.httpparser.api.common.KnownHeaderName;
import org.webpieces.webserver.test.ResponseExtract;
import org.webpieces.webserver.test.ResponseWrapper;

public class WebBrowserSimulator {
    private HttpSocket socket;
    private Map<String, String> cookieToValue = new HashMap<String, String>();

    public WebBrowserSimulator(HttpSocket socket) {
        this.socket = socket;
    }

    public ResponseWrapper send(HttpFullRequest request) {
        if (this.cookieToValue.size() > 0) {
            request.addHeader(this.createCookieHeader());
        }
        CompletableFuture respFuture = this.socket.send(request);
        ResponseWrapper responseWrapper = ResponseExtract.waitResponseAndWrap(respFuture);
        this.cookieToValue = responseWrapper.modifyCookieMap(this.cookieToValue);
        return responseWrapper;
    }

    public Header createCookieHeader() {
        boolean isFirstLine = true;
        Object fullRequestCookie = "";
        for (Map.Entry<String, String> entry : this.cookieToValue.entrySet()) {
            if (isFirstLine) {
                isFirstLine = false;
                fullRequestCookie = (String)fullRequestCookie + entry.getKey() + "=" + entry.getValue();
                continue;
            }
            fullRequestCookie = (String)fullRequestCookie + "; " + entry.getKey() + "=" + entry.getValue();
        }
        return new Header(KnownHeaderName.COOKIE, (String)fullRequestCookie);
    }
}

