/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.webserver.test.http11;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import javax.net.ssl.SSLEngine;
import org.webpieces.data.api.BufferPool;
import org.webpieces.data.api.TwoPools;
import org.webpieces.httpclient11.api.HttpClient;
import org.webpieces.httpclient11.api.HttpSocket;
import org.webpieces.httpclient11.api.HttpSocketListener;
import org.webpieces.httpclient11.impl.ChannelProxy;
import org.webpieces.httpclient11.impl.HttpSocketImpl;
import org.webpieces.httpparser.api.HttpParser;
import org.webpieces.httpparser.api.HttpParserFactory;
import org.webpieces.nio.api.handlers.ConnectionListener;
import org.webpieces.webserver.test.MockChannelManager;
import org.webpieces.webserver.test.MockTcpChannel;
import org.webpieces.webserver.test.http11.DelayedProxy;

public class DirectHttp11Client
implements HttpClient {
    private MockChannelManager mgr;
    private HttpParser parser = HttpParserFactory.createParser((String)"a", (MeterRegistry)new SimpleMeterRegistry(), (BufferPool)new TwoPools("pl", (MeterRegistry)new SimpleMeterRegistry()));

    public DirectHttp11Client(MockChannelManager mgr) {
        this.mgr = mgr;
    }

    public HttpSocket createHttpSocket(HttpSocketListener closeListener) {
        ConnectionListener listener = this.mgr.getHttpConnection();
        MockTcpChannel channel = new MockTcpChannel(false);
        return new HttpSocketImpl((ChannelProxy)new DelayedProxy(listener, channel), this.parser, closeListener, false);
    }

    public HttpSocket createHttpsSocket(SSLEngine engine, HttpSocketListener closeListener) {
        ConnectionListener listener = this.mgr.getHttpsConnection();
        MockTcpChannel channel = new MockTcpChannel(true);
        return new HttpSocketImpl((ChannelProxy)new DelayedProxy(listener, channel), this.parser, closeListener, true);
    }
}

