/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.webserver.test.http2;

import com.google.inject.Module;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLEngine;
import org.webpieces.http2client.api.Http2Client;
import org.webpieces.http2client.api.Http2Socket;
import org.webpieces.http2client.api.Http2SocketListener;
import org.webpieces.httpclientx.api.Http2to11ClientFactory;
import org.webpieces.mock.time.MockTime;
import org.webpieces.mock.time.MockTimer;
import org.webpieces.nio.api.BackpressureConfig;
import org.webpieces.util.exceptions.SneakyThrow;
import org.webpieces.webserver.test.MockChannelManager;
import org.webpieces.webserver.test.OverridesForEmbeddedSvrWithParsing;
import org.webpieces.webserver.test.OverridesForTestRealServer;
import org.webpieces.webserver.test.http2.NullCloseListener;
import org.webpieces.webserver.test.http2.TestMode;
import org.webpieces.webserver.test.http2.direct.DirectHttp2Client;
import org.webpieces.webserver.test.http2.directfast.DirectFastClient;
import org.webpieces.webserver.test.http2.directfast.MockFrontendManager;
import org.webpieces.webserver.test.http2.directfast.OverridesForEmbeddedSvrNoParsing;

public abstract class AbstractHttp2Test {
    protected MockChannelManager mgr = new MockChannelManager();
    protected MockFrontendManager frontEnd = new MockFrontendManager();
    protected MockTime time = new MockTime(true);
    protected MockTimer mockTimer = new MockTimer();

    public Http2Socket connectHttp(InetSocketAddress addr) {
        return this.connectHttp(addr, null);
    }

    public Http2Socket connectHttp(InetSocketAddress addr, Http2SocketListener listener) {
        try {
            if (listener == null) {
                listener = new NullCloseListener();
            }
            Http2Socket socket = this.getClient().createHttpSocket(listener);
            CompletableFuture connect = socket.connect(addr);
            connect.get(2L, TimeUnit.SECONDS);
            return socket;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw SneakyThrow.sneak((Throwable)e);
        }
    }

    public Http2Socket connectHttps(SSLEngine engine, InetSocketAddress addr) {
        return this.connectHttps(engine, addr, null);
    }

    public Http2Socket connectHttps(SSLEngine engine, InetSocketAddress addr, Http2SocketListener listener) {
        try {
            if (listener == null) {
                listener = new NullCloseListener();
            }
            Http2Socket socket = this.getClient().createHttpsSocket(engine, listener);
            CompletableFuture connect = socket.connect(addr);
            connect.get(2L, TimeUnit.SECONDS);
            return socket;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw SneakyThrow.sneak((Throwable)e);
        }
    }

    protected Module getOverrides(MeterRegistry metrics) {
        if (this.getTestMode() == TestMode.REMOTE) {
            return new OverridesForTestRealServer(metrics);
        }
        if (this.getTestMode() == TestMode.EMBEDDED_DIRET_NO_PARSING) {
            return new OverridesForEmbeddedSvrNoParsing(this.frontEnd, this.time, this.mockTimer, metrics);
        }
        return new OverridesForEmbeddedSvrWithParsing(this.mgr, this.time, this.mockTimer, metrics);
    }

    protected Http2Client getClient() {
        if (this.getTestMode() == TestMode.REMOTE) {
            return this.createRemoteClient();
        }
        if (this.getTestMode() == TestMode.EMBEDDED_DIRET_NO_PARSING) {
            return new DirectFastClient(this.frontEnd);
        }
        return new DirectHttp2Client(this.mgr);
    }

    protected Http2Client createRemoteClient() {
        return Http2to11ClientFactory.createHttpClient((String)"testClient", (int)5, (BackpressureConfig)new BackpressureConfig(), (MeterRegistry)Metrics.globalRegistry);
    }

    protected TestMode getTestMode() {
        return TestMode.EMBEDDED_DIRET_NO_PARSING;
    }
}

