/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.webserver.test.http2;

import com.webpieces.http2.api.dto.highlevel.Http2Response;
import com.webpieces.http2.api.dto.lowlevel.lib.Http2Header;
import com.webpieces.http2.api.dto.lowlevel.lib.Http2HeaderName;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.data.api.DataWrapperGenerator;
import org.webpieces.data.api.DataWrapperGeneratorFactory;
import org.webpieces.http.StatusCode;
import org.webpieces.http2client.api.dto.ContentType;
import org.webpieces.http2client.api.dto.FullResponse;
import org.webpieces.util.exceptions.SneakyThrow;

public class ResponseWrapperHttp2 {
    private static final Charset DEFAULT_CHARSET = Charset.forName("ISO-8859-1");
    private DataWrapperGenerator dataGen = DataWrapperGeneratorFactory.createDataWrapperGenerator();
    private final FullResponse fullResp;

    public ResponseWrapperHttp2(FullResponse resp) {
        this.fullResp = resp;
    }

    public Http2Response getResponse() {
        return this.fullResp.getHeaders();
    }

    public DataWrapper getBody() {
        return this.fullResp.getPayload();
    }

    public String getBodyAsString() {
        Charset charset = this.extractCharset();
        DataWrapper body = this.getBody();
        if (body == null) {
            return null;
        }
        return body.createStringFrom(0, body.getReadableSize(), charset);
    }

    private Charset extractCharset() {
        Http2Header header = this.getResponse().getHeaderLookupStruct().getHeader(Http2HeaderName.CONTENT_TYPE);
        if (header == null) {
            throw new IllegalArgumentException("no ContentType header could be found");
        }
        ContentType ct = ContentType.parse((Http2Header)header);
        Charset charset = DEFAULT_CHARSET;
        if (ct.getCharSet() != null) {
            charset = Charset.forName(ct.getCharSet());
        }
        return charset;
    }

    public void assertStatusCode(StatusCode status) {
        StatusCode knownStatus = this.getResponse().getKnownStatusCode();
        if (status != knownStatus) {
            throw new IllegalStateException("Expected status=" + status + " but received=" + knownStatus);
        }
    }

    public void assertContains(String text) {
        String bodyAsString = this.getBodyAsString();
        if (!bodyAsString.contains(text)) {
            throw new IllegalStateException("Expected body to contain='" + text + "' but body was=" + bodyAsString);
        }
    }

    public void assertNotContains(String text) {
        String bodyAsString = this.getBodyAsString();
        if (bodyAsString.contains(text)) {
            throw new IllegalStateException("Expected body to NOT contain='" + text + "' but body was=" + bodyAsString);
        }
    }

    public void assertContentType(String mimeType) {
        Http2Header type = this.getResponse().getHeaderLookupStruct().getHeader(Http2HeaderName.CONTENT_TYPE);
        String value = type.getValue();
        if (!mimeType.equals(value)) {
            throw new IllegalStateException("Expected mimeType=" + mimeType + " but found type=" + value);
        }
    }

    public void uncompressBodyAndAssertContainsString(String text) {
        Http2Header header = this.getResponse().getHeaderLookupStruct().getHeader(Http2HeaderName.CONTENT_ENCODING);
        if (header == null) {
            throw new IllegalStateException("Body is not compressed as no CONTENT_ENCODING header field exists");
        }
        if (!"gzip".equals(header.getValue())) {
            throw new IllegalStateException("Body has wrong compression type=" + header.getValue() + " in CONTENT_ENCODING header field");
        }
        DataWrapper wrapper = this.getBody();
        byte[] compressed = wrapper.createByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(compressed);
        byte[] out = new byte[10000];
        DataWrapper output = this.dataGen.emptyWrapper();
        try (GZIPInputStream str = new GZIPInputStream(in);){
            int read = 0;
            while ((read = str.read(out)) > 0) {
                ByteBuffer buffer = ByteBuffer.wrap(out, 0, read);
                DataWrapper byteWrapper = this.dataGen.wrapByteBuffer(buffer);
                output = this.dataGen.chainDataWrappers(output, byteWrapper);
                out = new byte[10000];
            }
        }
        catch (IOException e) {
            throw SneakyThrow.sneak((Throwable)e);
        }
        Charset charset = this.extractCharset();
        String bodyAsString = output.createStringFrom(0, output.getReadableSize(), charset);
        if (!bodyAsString.contains(text)) {
            throw new IllegalStateException("Expected compressed body to contain='" + text + "' but body was=" + bodyAsString);
        }
    }

    public String getRedirectUrl() {
        Http2Header header = this.getResponse().getHeaderLookupStruct().getHeader(Http2HeaderName.LOCATION);
        if (header == null) {
            return null;
        }
        return header.getValue();
    }

    public Map<String, String> modifyCookieMap(Map<String, String> currentCookies) {
        List headers = this.getResponse().getHeaderLookupStruct().getHeaders(Http2HeaderName.SET_COOKIE);
        for (Http2Header header : headers) {
            String value = header.getValue();
            if (value.contains(";")) {
                String[] split = value.split(";");
                value = split[0];
            }
            int indexOf = value.indexOf("=");
            String key = value.substring(0, indexOf);
            String val = value.substring(indexOf + 1);
            if (val.length() <= 0) {
                currentCookies.remove(key);
                continue;
            }
            currentCookies.put(key, val);
        }
        return currentCookies;
    }

    public Http2Header createCookieRequestHeader() {
        List headers = this.getResponse().getHeaderLookupStruct().getHeaders(Http2HeaderName.SET_COOKIE);
        Object fullRequestCookie = "";
        boolean firstLine = true;
        for (Http2Header header : headers) {
            String[] keyVal;
            String value = header.getValue();
            if (value.contains(";")) {
                String[] split = value.split(";");
                value = split[0];
            }
            if ((keyVal = value.split("=")).length <= 1) continue;
            if (firstLine) {
                firstLine = false;
                fullRequestCookie = (String)fullRequestCookie + value;
                continue;
            }
            fullRequestCookie = (String)fullRequestCookie + "; " + value;
        }
        return new Http2Header(Http2HeaderName.COOKIE, (String)fullRequestCookie);
    }
}

