/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.webserver.test.http2.direct;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.webpieces.http2client.impl.Http2ChannelProxy;
import org.webpieces.nio.api.channels.Channel;
import org.webpieces.nio.api.handlers.ConnectionListener;
import org.webpieces.nio.api.handlers.DataListener;
import org.webpieces.webserver.test.MockTcpChannel;

public class DelayedProxy
implements Http2ChannelProxy {
    private ConnectionListener listener;
    private MockTcpChannel channel;
    private DataListener toServerDataListener;

    public DelayedProxy(ConnectionListener listener, MockTcpChannel channel) {
        this.listener = listener;
        this.channel = channel;
    }

    public CompletableFuture<Void> connect(InetSocketAddress addr, DataListener dataListener) {
        this.channel.setDataListener(dataListener);
        return this.listener.connected((Channel)this.channel, true).thenApply(d -> {
            this.toServerDataListener = d;
            return null;
        });
    }

    public CompletableFuture<Void> write(ByteBuffer buffer) {
        return this.toServerDataListener.incomingData((Channel)this.channel, buffer);
    }

    public CompletableFuture<Void> close() {
        this.toServerDataListener.farEndClosed((Channel)this.channel);
        return CompletableFuture.completedFuture(null);
    }
}

