/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.webserver.test.http2.direct;

import com.webpieces.hpack.api.HpackParser;
import com.webpieces.hpack.api.HpackParserFactory;
import com.webpieces.http2engine.api.client.Http2ClientEngineFactory;
import com.webpieces.http2engine.api.client.Http2Config;
import com.webpieces.http2engine.api.client.InjectionConfig;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import javax.net.ssl.SSLEngine;
import org.webpieces.data.api.BufferPool;
import org.webpieces.data.api.TwoPools;
import org.webpieces.http2client.api.Http2Client;
import org.webpieces.http2client.api.Http2Socket;
import org.webpieces.http2client.api.Http2SocketListener;
import org.webpieces.http2client.impl.Http2ChannelProxy;
import org.webpieces.http2client.impl.Http2SocketImpl;
import org.webpieces.nio.api.handlers.ConnectionListener;
import org.webpieces.util.time.Time;
import org.webpieces.util.time.TimeImpl;
import org.webpieces.webserver.test.MockChannelManager;
import org.webpieces.webserver.test.MockTcpChannel;
import org.webpieces.webserver.test.http2.direct.DelayedProxy;

public class DirectHttp2Client
implements Http2Client {
    private Http2ClientEngineFactory factory;
    private MockChannelManager mgr;

    public DirectHttp2Client(MockChannelManager mgr) {
        this.mgr = mgr;
        SimpleMeterRegistry metrics = new SimpleMeterRegistry();
        TwoPools pool = new TwoPools("directhttp2.bufferpool", (MeterRegistry)metrics);
        HpackParser hpackParser = HpackParserFactory.createParser((BufferPool)pool, (boolean)false);
        Http2Config config = new Http2Config();
        InjectionConfig injConfig = new InjectionConfig(hpackParser, (Time)new TimeImpl(), config);
        this.factory = new Http2ClientEngineFactory(injConfig);
    }

    public Http2Socket createHttpSocket(Http2SocketListener socketListener) {
        ConnectionListener listener = this.mgr.getHttpConnection();
        MockTcpChannel channel = new MockTcpChannel(false);
        return new Http2SocketImpl((Http2ChannelProxy)new DelayedProxy(listener, channel), this.factory, socketListener);
    }

    public Http2Socket createHttpsSocket(SSLEngine engine, Http2SocketListener socketListener) {
        ConnectionListener listener = this.mgr.getHttpConnection();
        MockTcpChannel channel = new MockTcpChannel(true);
        return new Http2SocketImpl((Http2ChannelProxy)new DelayedProxy(listener, channel), this.factory, socketListener);
    }
}

