/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.webserver.test.http2.directfast;

import com.webpieces.http2.api.streaming.RequestStreamHandle;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import org.webpieces.frontend2.api.FrontendSocket;
import org.webpieces.frontend2.api.HttpStream;
import org.webpieces.frontend2.api.StreamListener;
import org.webpieces.http2client.api.Http2Socket;
import org.webpieces.http2client.api.Http2SocketListener;
import org.webpieces.http2client.api.dto.FullRequest;
import org.webpieces.http2client.api.dto.FullResponse;
import org.webpieces.http2client.impl.ResponseCacher;
import org.webpieces.webserver.test.http2.directfast.MockFrontendSocket;
import org.webpieces.webserver.test.http2.directfast.ProxyClose;
import org.webpieces.webserver.test.http2.directfast.ProxyRequestStreamHandle;

public class MockHttp2Socket
implements Http2Socket {
    private StreamListener streamListener;
    private MockFrontendSocket frontendSocket;

    public MockHttp2Socket(Http2SocketListener closeListener, StreamListener streamListener, boolean isHttps) {
        this.streamListener = streamListener;
        this.frontendSocket = new MockFrontendSocket(isHttps, new ProxyClose(closeListener, this));
    }

    public CompletableFuture<Void> connect(InetSocketAddress addr) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<FullResponse> send(FullRequest request) {
        return new ResponseCacher(() -> this.openStream()).run(request);
    }

    public RequestStreamHandle openStream() {
        if (this.streamListener == null) {
            String protocol = "http";
            if (this.frontendSocket.isForServingHttpsPages()) {
                protocol = "https";
            }
            throw new IllegalStateException("Your arguments on webpieces startup told us not to bind a server for protocol=" + protocol);
        }
        HttpStream stream = this.streamListener.openStream((FrontendSocket)this.frontendSocket);
        return new ProxyRequestStreamHandle(stream, this.frontendSocket);
    }

    public CompletableFuture<Void> close() {
        this.streamListener.fireIsClosed((FrontendSocket)this.frontendSocket);
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> sendPing() {
        throw new UnsupportedOperationException("not supported");
    }
}

