/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.webserver.test.http2.directfast;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webpieces.frontend2.api.HttpFrontendManager;
import org.webpieces.mock.time.MockTime;
import org.webpieces.mock.time.MockTimer;
import org.webpieces.templatingdev.api.DevTemplateModule;
import org.webpieces.templatingdev.api.TemplateCompileConfig;
import org.webpieces.util.threading.DirectExecutorService;
import org.webpieces.util.time.Time;
import org.webpieces.webserver.test.http2.directfast.MockFrontendManager;

public class OverridesForEmbeddedSvrNoParsing
implements Module {
    private static final Logger log = LoggerFactory.getLogger(OverridesForEmbeddedSvrNoParsing.class);
    private MockFrontendManager frontEnd;
    private MockTime time;
    private MockTimer mockTimer;
    private MeterRegistry metrics;
    private TemplateCompileConfig templateConfig;

    public OverridesForEmbeddedSvrNoParsing(MockFrontendManager frontEnd, MockTime time, MockTimer mockTimer, MeterRegistry metrics) {
        this.frontEnd = frontEnd;
        this.time = time;
        this.mockTimer = mockTimer;
        this.metrics = metrics;
        this.templateConfig = new TemplateCompileConfig(OverridesForEmbeddedSvrNoParsing.isGradleRunning());
    }

    public void configure(Binder binder) {
        binder.bind(HttpFrontendManager.class).toInstance((Object)this.frontEnd);
        binder.bind(MeterRegistry.class).toInstance((Object)this.metrics);
        binder.bind(Time.class).toInstance((Object)this.time);
        binder.bind(ScheduledExecutorService.class).toInstance((Object)this.mockTimer);
        binder.install((Module)new DevTemplateModule(this.templateConfig));
    }

    @Provides
    @Singleton
    @Named(value="fileReadExecutor")
    public ExecutorService provideExecutor() {
        return new DirectExecutorService();
    }

    public static boolean isGradleRunning() {
        String property = System.getProperty("gradle.running");
        if ("true".equals(property)) {
            log.info("gradle running.  using class files from filesystem");
            return true;
        }
        log.info("gradle NOT running.  generating groovy class files for test so test doesn't fail with class not found in IDE ever");
        return false;
    }
}

