/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.plugins.sslcert;

import com.webpieces.hpack.api.dto.Http2Response;
import com.webpieces.http2parser.api.dto.lib.Http2Header;
import com.webpieces.http2parser.api.dto.lib.Http2HeaderName;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.security.KeyPair;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.jose4j.base64url.Base64;
import org.shredzone.acme4j.util.KeyPairUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webpieces.ctx.api.Current;
import org.webpieces.ctx.api.RouterRequest;
import org.webpieces.plugins.backend.menu.MenuCreator;
import org.webpieces.plugins.sslcert.CertAndSigningRequest;
import org.webpieces.plugins.sslcert.InstallSslCertRouteId;
import org.webpieces.plugins.sslcert.acme.AcmeClientProxy;
import org.webpieces.plugins.sslcert.acme.AcmeInfo;
import org.webpieces.plugins.sslcert.acme.ProxyAuthorization;
import org.webpieces.plugins.sslcert.acme.ProxyOrder;
import org.webpieces.router.api.SimpleStorage;
import org.webpieces.router.api.actions.Action;
import org.webpieces.router.api.actions.Actions;
import org.webpieces.router.api.actions.Redirect;
import org.webpieces.router.api.actions.Render;
import org.webpieces.router.api.exceptions.NotFoundException;
import org.webpieces.router.api.routing.RouteId;

@Singleton
public class InstallSslCertController {
    private static final Logger log = LoggerFactory.getLogger(InstallSslCertController.class);
    private static final String EMAIL = "email";
    private static final String URL = "urlLocation";
    private SimpleStorage storage;
    private MenuCreator menuCreator;
    private AcmeClientProxy acmeClient;
    private DateTimeFormatter fmt = ISODateTimeFormat.dateTime();

    @Inject
    public InstallSslCertController(MenuCreator menuCreator, SimpleStorage storage, AcmeClientProxy acmeClient) {
        this.menuCreator = menuCreator;
        this.storage = storage;
        this.acmeClient = acmeClient;
    }

    public CompletableFuture<Action> sslSetup() {
        CompletableFuture read = this.storage.read("org.webpieces.plugins.sslcert");
        return read.thenCompose(properties -> this.decide((Map<String, String>)properties));
    }

    private CompletableFuture<Action> decide(Map<String, String> properties) {
        String base64 = properties.get("accountKeyPair");
        if (base64 == null) {
            log.info("accountKeyPair not found in database");
            CompletableFuture<AcmeInfo> future = this.acmeClient.fetchRemoteInfo();
            return future.thenApply(info -> Actions.renderThis((Object[])new Object[]{"menu", this.menuCreator.getMenu(), "agreement", "" + info.getTermsOfServiceUri(), "website", info.getWebsite()}));
        }
        log.info("accountKeyPair found in database.  redirecting to step 2");
        return CompletableFuture.completedFuture(Actions.redirect((RouteId)InstallSslCertRouteId.STEP2, (Object[])new Object[0]));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CompletableFuture<Redirect> postStartSslInstall(String email) {
        log.info("create key pair");
        KeyPair accountKeyPair = KeyPairUtils.createKeyPair((int)2048);
        log.info("done creating key pair");
        try (StringWriter writer = new StringWriter();){
            KeyPairUtils.writeKeyPair((KeyPair)accountKeyPair, (Writer)writer);
            log.info("done marshalling keypair to string");
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("accountKeyPair", writer.toString());
            properties.put(EMAIL, email);
            CompletionStage completionStage = this.storage.save("org.webpieces.plugins.sslcert", properties).thenApply(v -> {
                log.info("done saving, redirecting to step2");
                return Actions.redirect((RouteId)InstallSslCertRouteId.STEP2, (Object[])new Object[0]);
            });
            return completionStage;
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public CompletableFuture<Action> step2() {
        CompletableFuture read = this.storage.read("org.webpieces.plugins.sslcert");
        return read.thenApply(props -> this.decideStep2((Map<String, String>)props));
    }

    private Action decideStep2(Map<String, String> properties) {
        log.info("read in properties");
        String keyPair = properties.get("accountKeyPair");
        if (keyPair == null) {
            log.info("keyPair not foudn, redirecting to first step");
            return Actions.redirect((RouteId)InstallSslCertRouteId.INSTALL_SSL_SETUP, (Object[])new Object[0]);
        }
        log.info("rendering step");
        return Actions.renderThis((Object[])new Object[]{"menu", this.menuCreator.getMenu(), "keyPair", keyPair});
    }

    public CompletableFuture<Redirect> postStep2(String organization) {
        RouterRequest request = Current.request();
        return this.storage.read("org.webpieces.plugins.sslcert").thenCompose(props -> this.process((Map<String, String>)props, request, organization));
    }

    private CompletableFuture<Redirect> process(Map<String, String> props, RouterRequest request, String organization) {
        log.info("read in properties from database");
        String domain = request.domain;
        String accountKeyPairString = props.get("accountKeyPair");
        String email = props.get(EMAIL);
        try {
            KeyPair accountKeyPair = KeyPairUtils.readKeyPair((Reader)new StringReader(accountKeyPairString));
            log.info("deserialized keypair");
            return this.acmeClient.openAccount(email, accountKeyPair).thenCompose(url -> this.saveUrlAndProcessOrder((URL)url, accountKeyPair, email, domain, organization));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private CompletableFuture<Redirect> saveUrlAndProcessOrder(URL url, KeyPair accountKeyPair, String email, String domain, String organization) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.storage.save("org.webpieces.plugins.sslcert", URL, "" + url).thenCompose(nothing -> this.acmeClient.placeOrder(url, accountKeyPair))).thenCompose(order -> this.createWebPages((ProxyOrder)order))).thenCompose(order -> this.acmeClient.finalizeOrder((ProxyOrder)order, accountKeyPair, email, domain, organization))).thenCompose(cert -> this.installCertAllServers((CertAndSigningRequest)cert))).thenApply(nothing -> Actions.redirect((RouteId)InstallSslCertRouteId.MAINTAIN_SSL, (Object[])new Object[0]));
    }

    private CompletableFuture<ProxyOrder> createWebPages(ProxyOrder order) {
        List<ProxyAuthorization> authorizations = order.getAuthorizations();
        HashMap<String, CallSite> properties = new HashMap<String, CallSite>();
        for (ProxyAuthorization auth : authorizations) {
            log.info("process domain=" + auth.getDomain() + " expires=" + auth.getExpires() + " status=" + auth.getStatus() + " else=" + auth.getLocation());
            Instant expires = auth.getExpires();
            String dateTime = this.fmt.print(expires.getEpochSecond());
            String domain = auth.getDomain();
            String authContent = auth.getAuthContent();
            String value = authContent + "---" + domain + "---" + dateTime;
            String token = auth.getToken();
            log.info("putting token in map=" + token + " value=" + value);
            properties.put(token, (CallSite)((Object)value));
        }
        return this.storage.save("org.webpieces.plugins.sslcert", properties).thenApply(nothing -> order);
    }

    private CompletableFuture<Void> installCertAllServers(CertAndSigningRequest certInfo) {
        List<X509Certificate> certChain = certInfo.getCertChain();
        HashMap<String, String> props = new HashMap<String, String>();
        try {
            props.put("CSR", certInfo.getCsr());
            for (int i = 0; i < certChain.size(); ++i) {
                X509Certificate cert = certChain.get(i);
                String certString = Base64.encode((byte[])cert.getEncoded());
                props.put("certChain", certString);
            }
            return this.storage.save("org.webpieces.plugins.sslcert", props);
        }
        catch (CertificateEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public CompletableFuture<Render> renderToken(String token) {
        Current.getContext().addModifyResponse(http2Response -> this.modifyResponse(http2Response));
        CompletableFuture future = this.storage.read("org.webpieces.plugins.sslcert");
        return future.thenApply(props -> {
            String result = (String)props.get(token);
            log.info("token=" + token + " value=" + result);
            if (result == null) {
                throw new NotFoundException();
            }
            int index = result.indexOf("---");
            String authContent = result.substring(0, index);
            return Actions.renderThis((Object[])new Object[]{"authContent", authContent});
        });
    }

    private Object modifyResponse(Object http2Response) {
        Http2Response resp = (Http2Response)http2Response;
        Http2Header header = resp.getHeaderLookupStruct().getHeader(Http2HeaderName.CONTENT_TYPE);
        header.setValue("text/plain");
        return resp;
    }

    public Render maintainSsl() {
        return Actions.renderThis((Object[])new Object[0]);
    }
}

