/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.plugins.sslcert.acme;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.shredzone.acme4j.Account;
import org.shredzone.acme4j.AccountBuilder;
import org.shredzone.acme4j.Authorization;
import org.shredzone.acme4j.Certificate;
import org.shredzone.acme4j.Login;
import org.shredzone.acme4j.Metadata;
import org.shredzone.acme4j.Order;
import org.shredzone.acme4j.Session;
import org.shredzone.acme4j.Status;
import org.shredzone.acme4j.challenge.Http01Challenge;
import org.shredzone.acme4j.exception.AcmeException;
import org.shredzone.acme4j.util.CSRBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webpieces.plugins.sslcert.CertAndSigningRequest;
import org.webpieces.plugins.sslcert.ChallengeInBadStateException;
import org.webpieces.plugins.sslcert.InstallSslCertConfig;
import org.webpieces.plugins.sslcert.acme.AcmeInfo;
import org.webpieces.plugins.sslcert.acme.ProxyAuthorization;
import org.webpieces.plugins.sslcert.acme.ProxyOrder;
import org.webpieces.util.futures.CompletableFutureCollector;

public class AcmeClientProxy {
    private static final Logger log = LoggerFactory.getLogger(AcmeClientProxy.class);
    private InstallSslCertConfig config;

    @Inject
    public AcmeClientProxy(InstallSslCertConfig config) {
        this.config = config;
    }

    public CompletableFuture<AcmeInfo> fetchRemoteInfo() {
        try {
            Session session = new Session(this.config.getProviderLocation());
            Metadata metadata = session.getMetadata();
            URI termsOfServiceUri = metadata.getTermsOfService();
            URL website = metadata.getWebsite();
            return CompletableFuture.completedFuture(new AcmeInfo(termsOfServiceUri, website));
        }
        catch (AcmeException e) {
            throw new RuntimeException(e);
        }
    }

    public CompletableFuture<URL> openAccount(String email, KeyPair accountKeyPair) {
        try {
            log.info("open account");
            Session session = new Session("acme://letsencrypt.org/staging");
            Account account = new AccountBuilder().addContact("mailto:" + email).agreeToTermsOfService().useKeyPair(accountKeyPair).create(session);
            URL location = account.getLocation();
            log.info("account location=" + location);
            return CompletableFuture.completedFuture(location);
        }
        catch (AcmeException e) {
            throw new RuntimeException(e);
        }
    }

    public CompletableFuture<ProxyOrder> placeOrder(URL accountUrl, KeyPair accountKeyPair) {
        try {
            log.info("reestablish account from location=" + accountUrl + " and keypair");
            Session session = new Session("acme://letsencrypt.org/staging");
            Login login = session.login(accountUrl, accountKeyPair);
            Account account = login.getAccount();
            log.info("create an order");
            String domainTemp = "something.com";
            Order order = account.newOrder().domain(domainTemp).create();
            this.checkAuthStatii(order);
            ArrayList<ProxyAuthorization> auths = new ArrayList<ProxyAuthorization>();
            for (Authorization auth : order.getAuthorizations()) {
                auths.add(new ProxyAuthorization(auth));
            }
            return CompletableFuture.completedFuture(new ProxyOrder(order, auths));
        }
        catch (AcmeException e) {
            throw new RuntimeException(e);
        }
    }

    public CompletableFuture<CertAndSigningRequest> finalizeOrder(ProxyOrder order, KeyPair accountKeyPair, String email, String domain, String organization) {
        Stream stream = order.getOrder().getAuthorizations().stream();
        Stream<CompletableFuture> futures = stream.map(auth -> this.processChallenge((Authorization)auth));
        CompletableFuture results = (CompletableFuture)futures.collect(CompletableFutureCollector.allOf());
        return results.thenCompose(nothing -> this.finalizeOrder(order, domain, organization, accountKeyPair));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CompletableFuture<CertAndSigningRequest> finalizeOrder(ProxyOrder proxyOrder, String domain, String organization, KeyPair accountKeyPair) {
        try (StringWriter writer = new StringWriter();){
            Order order = proxyOrder.getOrder();
            CSRBuilder csrb = new CSRBuilder();
            csrb.addDomain(domain);
            csrb.setOrganization(organization);
            csrb.sign(accountKeyPair);
            byte[] csr = csrb.getEncoded();
            order.execute(csr);
            while (order.getStatus() != Status.VALID) {
                Thread.sleep(3000L);
                order.update();
            }
            csrb.write((Writer)writer);
            Certificate cert = order.getCertificate();
            CompletableFuture<CertAndSigningRequest> completableFuture = CompletableFuture.completedFuture(new CertAndSigningRequest(writer.toString(), cert.getCertificateChain()));
            return completableFuture;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (AcmeException e) {
            throw new RuntimeException(e);
        }
    }

    private CompletableFuture<Void> processChallenge(Authorization auth) {
        try {
            Http01Challenge challenge = (Http01Challenge)auth.findChallenge("http-01");
            log.info("tell remote end to trigger a call now. status=" + auth.getStatus() + " domain=" + auth.getDomain() + " expires=" + auth.getExpires());
            challenge.trigger();
            log.info("status after=" + auth.getStatus());
            while (auth.getStatus() != Status.VALID) {
                Thread.sleep(3000L);
                log.info("reupdate status");
                auth.update();
                log.info("updated to status=" + auth.getStatus());
            }
            return null;
        }
        catch (AcmeException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkAuthStatii(Order order) {
        for (Authorization auth : order.getAuthorizations()) {
            Status status = auth.getStatus();
            log.info("checking auth=" + auth.getDomain() + " status=" + status + " location=" + auth.getLocation() + " expires=" + auth.getExpires());
            if (status == Status.PENDING) continue;
            throw new ChallengeInBadStateException("challenge in bad state=" + auth.getJSON());
        }
    }
}

