/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.plugins.json;

import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.webpieces.httpparser.api.dto.KnownStatusCode;
import org.webpieces.plugins.json.Jackson;
import org.webpieces.plugins.json.JacksonCatchAllFilter;
import org.webpieces.router.api.BodyContentBinder;
import org.webpieces.router.api.actions.RenderContent;
import org.webpieces.router.api.exceptions.ClientDataError;

public class JacksonLookup
implements BodyContentBinder {
    private ObjectMapper mapper;

    @Inject
    public JacksonLookup(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public <T> boolean isManaged(Class<T> entityClass, Class<? extends Annotation> paramAnnotation) {
        return paramAnnotation == Jackson.class || JsonNode.class.isAssignableFrom(entityClass);
    }

    public <T> T unmarshal(Class<T> entityClass, byte[] data) {
        try {
            if (data.length == 0) {
                throw new ClientDataError("Client did not provide a json request in the body of the request");
            }
            if (JsonNode.class.isAssignableFrom(entityClass)) {
                return (T)this.mapper.readTree(data);
            }
            return (T)this.mapper.readValue(data, entityClass);
        }
        catch (JsonProcessingException e) {
            throw new ClientDataError("invalid json in client request.  " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new RuntimeException("should not occur", e);
        }
    }

    public <T> RenderContent marshal(T bean) {
        try {
            byte[] content = bean == null ? new byte[]{} : this.mapper.writeValueAsBytes(bean);
            return new RenderContent(content, KnownStatusCode.HTTP_200_OK.getCode(), KnownStatusCode.HTTP_200_OK.getReason(), JacksonCatchAllFilter.MIME_TYPE);
        }
        catch (IOException e) {
            throw new RuntimeException("should not occur", e);
        }
    }

    public Class<? extends Annotation> getAnnotation() {
        return Jackson.class;
    }
}

