/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.projects;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class FileCopy {
    private File newAppDirectory;
    private String appClassName;
    private String packageStr;
    private String[] packagePieces;
    private String appName;
    private File webpiecesDir;
    private String packageDir;
    private String version;
    private String secretKeyBase64;

    public FileCopy(File webpiecesDir, String appClassName, String appName, String packageStr, File newAppDirectory, String version) {
        this.webpiecesDir = webpiecesDir;
        this.newAppDirectory = newAppDirectory;
        this.appClassName = appClassName;
        this.appName = appName;
        this.packageStr = packageStr;
        this.packageDir = this.convert(packageStr);
        this.packagePieces = packageStr.split("\\.");
        this.version = version;
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance("HmacSHA1");
            SecretKey key = keyGen.generateKey();
            byte[] encoded = key.getEncoded();
            this.secretKeyBase64 = Base64.getEncoder().encodeToString(encoded);
            byte[] decoded = Base64.getDecoder().decode(this.secretKeyBase64);
            System.out.println("secret Key=" + this.secretKeyBase64 + " bytes length=" + decoded.length);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private String convert(String packageStr2) {
        return packageStr2.replace(".", "/");
    }

    public void createProject() throws IOException {
        File template = new File(this.webpiecesDir, "templateProject");
        System.out.println("/n");
        System.out.println("copy from directory=" + template.getCanonicalPath());
        System.out.println("copy to directory  =" + this.newAppDirectory.getCanonicalPath());
        this.copyFiles(template, this.newAppDirectory);
    }

    private void copyFiles(File template, File targetDirectory) throws IOException {
        if (!template.exists()) {
            throw new IllegalArgumentException("Directory=" + template.getCanonicalPath() + "does not exist");
        }
        for (File f : template.listFiles()) {
            if (f.isDirectory()) {
                this.copyDirectory(f, targetDirectory);
                continue;
            }
            this.copyFile(f, targetDirectory);
        }
    }

    private void copyFile(File f, File targetDirectory) {
        String newFileName = this.getFileName(f);
        File newFile = new File(targetDirectory, newFileName);
        try {
            String contents;
            Files.copy(f.toPath(), newFile.toPath(), StandardCopyOption.COPY_ATTRIBUTES);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Files.copy(newFile.toPath(), out);
            String original = contents = new String(out.toByteArray(), Charset.defaultCharset());
            contents = contents.replace("/WEBPIECESxPACKAGE/", "/" + this.packageDir + "/");
            contents = contents.replace("WEBPIECESxPACKAGE", this.packageStr);
            contents = contents.replace("WEBPIECESxCLASS", this.appClassName);
            contents = contents.replace("WEBPIECESxAPPNAME", this.appName);
            contents = contents.replace("//@Ignore", "@Ignore");
            contents = contents.replace("//import org.junit.Ignore;", "import org.junit.Ignore;");
            contents = contents.replace("WEBPIECESxVERSION", this.version);
            contents = contents.replace("__SECRETKEYHERE__", this.secretKeyBase64);
            if (contents.equals(original)) {
                return;
            }
            ByteArrayInputStream in = new ByteArrayInputStream(contents.getBytes(Charset.defaultCharset()));
            Files.copy(in, newFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void copyDirectory(File f, File targetDirectory) throws IOException {
        String name = this.getFileName(f);
        String[] pieces = new String[]{name};
        if ("WEBPIECESxPACKAGE".equals(name)) {
            pieces = this.packagePieces;
        }
        File toCreate = this.createPackageFile(targetDirectory, pieces);
        toCreate.mkdirs();
        System.out.println("copy from directory=" + f.getCanonicalPath());
        System.out.println("copy to directory  =" + toCreate.getCanonicalPath());
        this.copyFiles(f, toCreate);
    }

    private String getFileName(File f) {
        String name = f.getName();
        if (name.contains("WEBPIECESxAPPNAME")) {
            name = name.replace("WEBPIECESxAPPNAME", this.appName);
        }
        if (name.endsWith("GRA")) {
            name = name.replace("GRA", "gradle");
        }
        if (name.contains("WEBPIECESxCLASS")) {
            name = name.replace("WEBPIECESxCLASS", this.appClassName);
        }
        return name;
    }

    private File createPackageFile(File targetDirectory, String[] pieces) {
        File f = targetDirectory;
        for (String name : pieces) {
            System.out.println("piece=" + name);
            f = new File(f, name);
        }
        return f;
    }
}

