/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.templatingdev.impl.source;

import java.util.HashMap;
import java.util.Map;
import org.webpieces.templatingdev.api.ScriptOutput;
import org.webpieces.templatingdev.api.Token;
import org.webpieces.templatingdev.impl.source.TokenImpl;

public class ScriptOutputImpl
implements ScriptOutput {
    private StringBuffer scriptSourceCode = new StringBuffer();
    private int currentLine = 1;
    private Map<Integer, Integer> scriptLineNumToHtmlLineNum = new HashMap<Integer, Integer>();
    private String packageStr;
    private String className;

    public ScriptOutputImpl(String packageStr, String className) {
        this.packageStr = packageStr;
        this.className = className;
    }

    @Override
    public void println(String text, Token forLineNumberComment) {
        this.scriptSourceCode.append(text);
        if (forLineNumberComment != null) {
            this.appendTokenComment(forLineNumberComment);
        }
        this.println();
    }

    @Override
    public void println() {
        this.scriptSourceCode.append("\n");
        ++this.currentLine;
    }

    @Override
    public void print(String text) {
        this.scriptSourceCode.append(text);
    }

    private void appendTokenComment(Token t) {
        TokenImpl token = (TokenImpl)t;
        this.scriptSourceCode.append(" //htmlLine ").append(token.beginLineNumber).append(":").append(token.endLineNumber).append("  groovyLine=").append(this.currentLine);
        this.scriptLineNumToHtmlLineNum.put(this.currentLine, token.beginLineNumber);
    }

    public String getScriptSourceCode() {
        return this.scriptSourceCode.toString();
    }

    public Map<Integer, Integer> getLineMapping() {
        return this.scriptLineNumToHtmlLineNum;
    }

    public int getLineNumber() {
        return this.currentLine;
    }

    public String getFullClassName() {
        if (this.packageStr != null) {
            return this.packageStr + "." + this.className;
        }
        return this.className;
    }

    public String toString() {
        return "ScriptOutputImpl.scriptSourceCode=\n\n" + this.scriptSourceCode;
    }
}

