/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.templatingdev.impl.source;

import java.util.ArrayList;
import java.util.List;
import org.webpieces.templatingdev.impl.source.TemplateToken;
import org.webpieces.templatingdev.impl.source.TokenImpl;

public class TemplateTokenizerTask {
    private String pageSource;
    private TemplateToken state = TemplateToken.PLAIN;
    private int end = 0;
    private int begin = 0;
    private int beginLineNumber = 0;
    private List<Integer> newLineMarks = new ArrayList<Integer>();
    private List<TokenImpl> tokens = new ArrayList<TokenImpl>();
    private String filePath;
    private int startTokenCount;

    public TemplateTokenizerTask(String filePath, String source) {
        this.filePath = filePath;
        if (source.contains("\r")) {
            throw new IllegalArgumentException("We rely on source input never containing \\r and only containing \\n for newlines");
        }
        this.pageSource = source;
    }

    public List<TokenImpl> parseSource() {
        int lineNumber = 1;
        int left = this.pageSource.length() - this.end;
        while (left != 0) {
            lineNumber = this.processNext3Chars(lineNumber, left);
            left = this.pageSource.length() - this.end;
        }
        if (this.state != TemplateToken.PLAIN) {
            TokenImpl token = this.tokens.get(this.tokens.size() - 1);
            int lastLine = token.endLineNumber;
            throw new IllegalArgumentException("File=" + this.filePath + " has an issue.  It is missing an end token of='" + this.state.getEnd() + "' where the start token was on line number=" + lastLine + " and start token of the tag looks like='" + this.state.getStart() + "'" + token.getSourceLocation(true));
        }
        ++this.end;
        this.found(TemplateToken.EOF, 0, lineNumber);
        return this.tokens;
    }

    private int processNext3Chars(int lineNumber, int left) {
        char c2;
        char c = this.pageSource.charAt(this.end);
        char c1 = left > 1 ? this.pageSource.charAt(this.end + 1) : (char)'\u0000';
        char c3 = c2 = left > 2 ? this.pageSource.charAt(this.end + 2) : (char)'\u0000';
        if (c == '\n') {
            this.newLineMarks.add(this.end);
            ++lineNumber;
        }
        ++this.end;
        switch (this.state) {
            case PLAIN: {
                this.processStartTagMatches(lineNumber, c, c1, c2);
                break;
            }
            default: {
                this.processEnd(lineNumber, c, c1, c2);
            }
        }
        return lineNumber;
    }

    private void processEnd(int lineNumber, char c, char c1, char c2) {
        switch (this.state) {
            case PLAIN: {
                throw new IllegalStateException("Should not be in state=PLAIN at this point ever");
            }
            case SCRIPT: {
                if (!TemplateToken.SCRIPT.matchesEnd(c, c1, c2)) break;
                this.found(TemplateToken.PLAIN, 2, lineNumber);
                break;
            }
            case FILE_VERIFY: {
                if (!TemplateToken.FILE_VERIFY.matchesEnd(c, c1, c2)) break;
                this.found(TemplateToken.PLAIN, 2, lineNumber);
                break;
            }
            case COMMENT: {
                if (!TemplateToken.COMMENT.matchesEnd(c, c1, c2)) break;
                this.found(TemplateToken.PLAIN, 2, lineNumber);
                break;
            }
            case ESCAPE: {
                if (!TemplateToken.ESCAPE.matchesEnd(c, c1, c2)) break;
                this.found(TemplateToken.PLAIN, 2, lineNumber);
                break;
            }
            case START_TAG: {
                if (TemplateToken.START_TAG.matchesEnd(c, c1, c2)) {
                    this.found(TemplateToken.PLAIN, 2, lineNumber);
                    break;
                }
                if (!TemplateToken.START_END_TAG.matchesEnd(c, c1, c2)) break;
                this.found(TemplateToken.PLAIN, 3, lineNumber, true, false);
                break;
            }
            case END_TAG: {
                if (!TemplateToken.END_TAG.matchesEnd(c, c1, c2)) break;
                this.found(TemplateToken.PLAIN, 2, lineNumber);
                break;
            }
            case EXPR: {
                if (!TemplateToken.EXPR.matchesEnd(c, c1, c2)) break;
                this.found(TemplateToken.PLAIN, 2, lineNumber);
                break;
            }
            case ACTION: {
                if (!TemplateToken.ACTION.matchesEnd(c, c1, c2)) break;
                this.found(TemplateToken.PLAIN, 2, lineNumber);
                break;
            }
            case ABSOLUTE_ACTION: {
                if (!TemplateToken.ABSOLUTE_ACTION.matchesEnd(c, c1, c2)) break;
                this.found(TemplateToken.PLAIN, 3, lineNumber);
                break;
            }
            case MESSAGE: {
                if (c == '&' && c1 == '{') {
                    ++this.startTokenCount;
                    break;
                }
                if (!TemplateToken.MESSAGE.matchesEnd(c, c1, c2)) break;
                if (this.startTokenCount == 0) {
                    this.found(TemplateToken.PLAIN, 2, lineNumber);
                    break;
                }
                --this.startTokenCount;
                break;
            }
            case EOF: 
            case START_END_TAG: {
                throw new RuntimeException("Should not reach here");
            }
        }
    }

    private void processStartTagMatches(int lineNumber, char c, char c1, char c2) {
        if (TemplateToken.SCRIPT.matchesStart(c, c1, c2)) {
            this.found(TemplateToken.SCRIPT, 2, lineNumber);
        } else if (TemplateToken.FILE_VERIFY.matchesStart(c, c1, c2)) {
            this.found(TemplateToken.FILE_VERIFY, 2, lineNumber);
        } else if (TemplateToken.EXPR.matchesStart(c, c1, c2)) {
            this.found(TemplateToken.EXPR, 2, lineNumber);
        } else if (TemplateToken.END_TAG.matchesStart(c, c1, c2)) {
            this.found(TemplateToken.END_TAG, 3, lineNumber);
        } else if (TemplateToken.START_TAG.matchesStart(c, c1, c2)) {
            this.found(TemplateToken.START_TAG, 2, lineNumber);
        } else if (TemplateToken.MESSAGE.matchesStart(c, c1, c2)) {
            this.found(TemplateToken.MESSAGE, 2, lineNumber);
        } else if (TemplateToken.ABSOLUTE_ACTION.matchesStart(c, c1, c2)) {
            this.found(TemplateToken.ABSOLUTE_ACTION, 3, lineNumber);
        } else if (TemplateToken.ACTION.matchesStart(c, c1, c2)) {
            this.found(TemplateToken.ACTION, 2, lineNumber);
        } else if (TemplateToken.COMMENT.matchesStart(c, c1, c2)) {
            this.found(TemplateToken.COMMENT, 2, lineNumber);
        } else if (TemplateToken.ESCAPE.matchesStart(c, c1, c2)) {
            this.found(TemplateToken.ESCAPE, 2, lineNumber);
        } else if (c == '\n') {
            this.found(TemplateToken.PLAIN, 1, lineNumber, false, true);
        }
    }

    private void found(TemplateToken newState, int skip, int endLineNumber) {
        this.found(newState, skip, endLineNumber, false, false);
    }

    private void found(TemplateToken newState, int skip, int endLineNumber, boolean isOpenCloseTag, boolean hasNewLine) {
        TemplateToken finalState = this.state;
        if (isOpenCloseTag) {
            finalState = TemplateToken.START_END_TAG;
        }
        --this.end;
        int endValue = this.end;
        if (hasNewLine) {
            ++endValue;
        }
        TokenImpl lastToken = new TokenImpl(this.filePath, this.begin, endValue, finalState, this.beginLineNumber, endLineNumber, this.pageSource);
        if (finalState != TemplateToken.PLAIN) {
            lastToken.verifyContentsHaveNoStartTag();
        }
        this.begin = this.end += skip;
        this.beginLineNumber = endLineNumber;
        this.state = newState;
        this.tokens.add(lastToken);
    }
}

