/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.templatingdev.impl.source;

import java.util.List;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webpieces.templatingdev.impl.source.ScriptOutputImpl;
import org.webpieces.templatingdev.impl.source.ScriptWriter;
import org.webpieces.templatingdev.impl.source.TemplateToken;
import org.webpieces.templatingdev.impl.source.TemplateTokenizer;
import org.webpieces.templatingdev.impl.source.TokenImpl;

public class GroovyScriptGenerator {
    private static final Logger log = LoggerFactory.getLogger(GroovyScriptGenerator.class);
    private TemplateTokenizer tokenizer;
    private ScriptWriter creator;

    @Inject
    public GroovyScriptGenerator(TemplateTokenizer tokenizer, ScriptWriter creator) {
        this.tokenizer = tokenizer;
        this.creator = creator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptOutputImpl generate(String filePath, String source, String fullClassName) {
        this.creator.init();
        long start = System.currentTimeMillis();
        source = source.replace("\r", "");
        List<TokenImpl> tokens = this.tokenizer.tokenize(filePath, source);
        String className = fullClassName;
        String packageStr = null;
        int index = fullClassName.lastIndexOf(".");
        if (index > 0) {
            className = fullClassName.substring(index + 1);
            packageStr = fullClassName.substring(0, index);
        }
        ScriptOutputImpl sourceCode = new ScriptOutputImpl(packageStr, className);
        try {
            this.creator.printHead(sourceCode, packageStr, className);
            this.generateBody(sourceCode, tokens);
            this.creator.printEnd(sourceCode);
        }
        finally {
            this.creator.cleanup();
        }
        TokenImpl token = tokens.get(tokens.size() - 1);
        int lastLine = token.endLineNumber;
        long total = System.currentTimeMillis() - start;
        log.info(total + "ms (dev mode only) source generation. class=" + className + " from " + lastLine + " html lines of code to " + sourceCode.getLineNumber() + " lines of groovy code");
        return sourceCode;
    }

    private void generateBody(ScriptOutputImpl sourceCode, List<TokenImpl> tokens) {
        block15: for (int i = 0; i < tokens.size(); ++i) {
            TokenImpl token = tokens.get(i);
            TokenImpl previousToken = null;
            if (i > 0) {
                previousToken = tokens.get(i - 1);
            }
            TemplateToken state = token.state;
            switch (state) {
                case EOF: {
                    return;
                }
                case PLAIN: {
                    this.creator.printPlain(token, sourceCode);
                    continue block15;
                }
                case SCRIPT: {
                    this.creator.printScript(token, sourceCode);
                    continue block15;
                }
                case FILE_VERIFY: {
                    this.creator.printFilePath(token, sourceCode);
                    continue block15;
                }
                case EXPR: {
                    this.creator.printExpression(token, sourceCode);
                    continue block15;
                }
                case MESSAGE: {
                    this.creator.printMessage(token, sourceCode);
                    continue block15;
                }
                case ACTION: {
                    this.creator.printAction(token, sourceCode, false);
                    continue block15;
                }
                case ABSOLUTE_ACTION: {
                    this.creator.printAction(token, sourceCode, true);
                    continue block15;
                }
                case COMMENT: {
                    this.creator.unprintUpToLastNewLine();
                    continue block15;
                }
                case ESCAPE: {
                    this.creator.printEscaped(token, sourceCode);
                    continue block15;
                }
                case START_END_TAG: {
                    this.creator.printStartEndTag(token, sourceCode);
                    continue block15;
                }
                case START_TAG: {
                    this.creator.printStartTag(token, previousToken, sourceCode);
                    continue block15;
                }
                case END_TAG: {
                    this.creator.printEndTag(token, sourceCode);
                }
            }
        }
    }
}

