/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.templatingdev.impl.tags;

import org.webpieces.templatingdev.api.AbstractGroovyGen;
import org.webpieces.templatingdev.api.ScriptOutput;
import org.webpieces.templatingdev.api.Token;

public class ElseIfGen
extends AbstractGroovyGen {
    @Override
    public String getName() {
        return "elseif";
    }

    @Override
    public void generateStart(ScriptOutput sourceCode, Token token, int uniqueId) {
        String cleanValue = token.getCleanValue();
        int indexOf = cleanValue.indexOf(" ");
        if (indexOf < 0) {
            throw new IllegalArgumentException("elseif statement is missing expression.  It must be #{elseif expression}# to work. " + token.getSourceLocation(true));
        }
        String expression = cleanValue.substring(indexOf + 1);
        sourceCode.println(" else if (" + expression + ") {", token);
        sourceCode.println();
    }

    @Override
    public void generateEnd(ScriptOutput sourceCode, Token token, int uniqueId) {
        sourceCode.println("}", token);
        sourceCode.println();
    }

    @Override
    public void validatePreviousSibling(Token current, Token prevous) {
        String name = this.getName();
        if (!prevous.isEndTag()) {
            throw new IllegalArgumentException(name + " tag is misused.  Either there is no previous #{/if}# tag OR\n it must be used like #{/if}##{elseif}# or #{/elseif}##{elseif}# with no\n spaces between the end if tag and begin else tag OR both #{/if}# and #{elseif}# must be on it's\n own lines with no text(only whitespace) or both #{/elseif}# and #{elseif}# must be on it's\n own lines with no text(only whitespace)\n #{" + name + "} is in error.  location=" + current.getSourceLocation(true));
        }
        String previousTagName = prevous.getCleanValue();
        if (!"if".equals(previousTagName) && !"elseif".equals(previousTagName)) {
            throw new IllegalArgumentException(name + " tag is missing the previous #{/if}# tag.  Instead we found a #{/" + previousTagName + "}# tag before the else. location=" + current.getSourceLocation(true));
        }
    }
}

