/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.templatingdev.impl.source;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.webpieces.templatingdev.impl.source.TemplateToken;
import org.webpieces.templatingdev.impl.source.TemplateTokenizerTask;
import org.webpieces.templatingdev.impl.source.TokenImpl;

public class TemplateTokenizer {
    private Set<TemplateToken> tagsToCleanWhitespace = new HashSet<TemplateToken>();

    public TemplateTokenizer() {
        this.tagsToCleanWhitespace.add(TemplateToken.START_TAG);
        this.tagsToCleanWhitespace.add(TemplateToken.END_TAG);
        this.tagsToCleanWhitespace.add(TemplateToken.START_END_TAG);
        this.tagsToCleanWhitespace.add(TemplateToken.COMMENT);
    }

    public List<TokenImpl> tokenize(String filePath, String source) {
        List<TokenImpl> tokens = new TemplateTokenizerTask(filePath, source).parseSource();
        return this.optimize(tokens);
    }

    private List<TokenImpl> optimize(List<TokenImpl> tokens) {
        for (int i = tokens.size() - 2; i >= 1; --i) {
            TokenImpl left = tokens.get(i - 1);
            TokenImpl token = tokens.get(i);
            TokenImpl right = tokens.get(i + 1);
            if (this.tagsToCleanWhitespace.contains((Object)token.state) && left.state == TemplateToken.PLAIN && right.state == TemplateToken.PLAIN) {
                if (!"".equals(left.getValue().trim()) || !"".equals(right.getValue().trim())) continue;
                tokens.remove(i + 1);
                if (token.state == TemplateToken.COMMENT) {
                    tokens.remove(i);
                }
                tokens.remove(i - 1);
                if (i < tokens.size()) continue;
                i = tokens.size() - 1;
                continue;
            }
            if (token.state != TemplateToken.PLAIN || !"".equals(token.getValue())) continue;
            tokens.remove(i);
        }
        return tokens;
    }
}

