/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal;

import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.whispersystems.libsignal.DecryptionCallback;
import org.whispersystems.libsignal.DuplicateMessageException;
import org.whispersystems.libsignal.InvalidKeyException;
import org.whispersystems.libsignal.InvalidKeyIdException;
import org.whispersystems.libsignal.InvalidMessageException;
import org.whispersystems.libsignal.LegacyMessageException;
import org.whispersystems.libsignal.NoSessionException;
import org.whispersystems.libsignal.SessionBuilder;
import org.whispersystems.libsignal.SignalProtocolAddress;
import org.whispersystems.libsignal.UntrustedIdentityException;
import org.whispersystems.libsignal.ecc.Curve;
import org.whispersystems.libsignal.ecc.ECKeyPair;
import org.whispersystems.libsignal.ecc.ECPublicKey;
import org.whispersystems.libsignal.protocol.CiphertextMessage;
import org.whispersystems.libsignal.protocol.PreKeySignalMessage;
import org.whispersystems.libsignal.protocol.SignalMessage;
import org.whispersystems.libsignal.ratchet.ChainKey;
import org.whispersystems.libsignal.ratchet.MessageKeys;
import org.whispersystems.libsignal.ratchet.RootKey;
import org.whispersystems.libsignal.state.IdentityKeyStore;
import org.whispersystems.libsignal.state.PreKeyStore;
import org.whispersystems.libsignal.state.SessionRecord;
import org.whispersystems.libsignal.state.SessionState;
import org.whispersystems.libsignal.state.SessionStore;
import org.whispersystems.libsignal.state.SignalProtocolStore;
import org.whispersystems.libsignal.state.SignedPreKeyStore;
import org.whispersystems.libsignal.util.ByteUtil;
import org.whispersystems.libsignal.util.Pair;
import org.whispersystems.libsignal.util.guava.Optional;

public class SessionCipher {
    public static final Object SESSION_LOCK = new Object();
    private final SessionStore sessionStore;
    private final SessionBuilder sessionBuilder;
    private final PreKeyStore preKeyStore;
    private final SignalProtocolAddress remoteAddress;

    public SessionCipher(SessionStore sessionStore, PreKeyStore preKeyStore, SignedPreKeyStore signedPreKeyStore, IdentityKeyStore identityKeyStore, SignalProtocolAddress remoteAddress) {
        this.sessionStore = sessionStore;
        this.preKeyStore = preKeyStore;
        this.remoteAddress = remoteAddress;
        this.sessionBuilder = new SessionBuilder(sessionStore, preKeyStore, signedPreKeyStore, identityKeyStore, remoteAddress);
    }

    public SessionCipher(SignalProtocolStore store, SignalProtocolAddress remoteAddress) {
        this(store, store, store, store, remoteAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CiphertextMessage encrypt(byte[] paddedMessage) {
        Object object = SESSION_LOCK;
        synchronized (object) {
            SessionRecord sessionRecord = this.sessionStore.loadSession(this.remoteAddress);
            SessionState sessionState = sessionRecord.getSessionState();
            ChainKey chainKey = sessionState.getSenderChainKey();
            MessageKeys messageKeys = chainKey.getMessageKeys();
            ECPublicKey senderEphemeral = sessionState.getSenderRatchetKey();
            int previousCounter = sessionState.getPreviousCounter();
            int sessionVersion = sessionState.getSessionVersion();
            byte[] ciphertextBody = this.getCiphertext(sessionVersion, messageKeys, paddedMessage);
            CiphertextMessage ciphertextMessage = new SignalMessage(sessionVersion, messageKeys.getMacKey(), senderEphemeral, chainKey.getIndex(), previousCounter, ciphertextBody, sessionState.getLocalIdentityKey(), sessionState.getRemoteIdentityKey());
            if (sessionState.hasUnacknowledgedPreKeyMessage()) {
                SessionState.UnacknowledgedPreKeyMessageItems items = sessionState.getUnacknowledgedPreKeyMessageItems();
                int localRegistrationId = sessionState.getLocalRegistrationId();
                ciphertextMessage = new PreKeySignalMessage(sessionVersion, localRegistrationId, items.getPreKeyId(), items.getSignedPreKeyId(), items.getBaseKey(), sessionState.getLocalIdentityKey(), (SignalMessage)ciphertextMessage);
            }
            sessionState.setSenderChainKey(chainKey.getNextChainKey());
            this.sessionStore.storeSession(this.remoteAddress, sessionRecord);
            return ciphertextMessage;
        }
    }

    public byte[] decrypt(PreKeySignalMessage ciphertext) throws DuplicateMessageException, LegacyMessageException, InvalidMessageException, InvalidKeyIdException, InvalidKeyException, UntrustedIdentityException {
        return this.decrypt(ciphertext, (DecryptionCallback)new NullDecryptionCallback());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decrypt(PreKeySignalMessage ciphertext, DecryptionCallback callback) throws DuplicateMessageException, LegacyMessageException, InvalidMessageException, InvalidKeyIdException, InvalidKeyException, UntrustedIdentityException {
        Object object = SESSION_LOCK;
        synchronized (object) {
            SessionRecord sessionRecord = this.sessionStore.loadSession(this.remoteAddress);
            Optional<Integer> unsignedPreKeyId = this.sessionBuilder.process(sessionRecord, ciphertext);
            byte[] plaintext = this.decrypt(sessionRecord, ciphertext.getWhisperMessage());
            callback.handlePlaintext(plaintext);
            this.sessionStore.storeSession(this.remoteAddress, sessionRecord);
            if (unsignedPreKeyId.isPresent()) {
                this.preKeyStore.removePreKey(unsignedPreKeyId.get());
            }
            return plaintext;
        }
    }

    public byte[] decrypt(SignalMessage ciphertext) throws InvalidMessageException, DuplicateMessageException, LegacyMessageException, NoSessionException {
        return this.decrypt(ciphertext, (DecryptionCallback)new NullDecryptionCallback());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decrypt(SignalMessage ciphertext, DecryptionCallback callback) throws InvalidMessageException, DuplicateMessageException, LegacyMessageException, NoSessionException {
        Object object = SESSION_LOCK;
        synchronized (object) {
            if (!this.sessionStore.containsSession(this.remoteAddress)) {
                throw new NoSessionException("No session for: " + this.remoteAddress);
            }
            SessionRecord sessionRecord = this.sessionStore.loadSession(this.remoteAddress);
            byte[] plaintext = this.decrypt(sessionRecord, ciphertext);
            callback.handlePlaintext(plaintext);
            this.sessionStore.storeSession(this.remoteAddress, sessionRecord);
            return plaintext;
        }
    }

    private byte[] decrypt(SessionRecord sessionRecord, SignalMessage ciphertext) throws DuplicateMessageException, LegacyMessageException, InvalidMessageException {
        Object object = SESSION_LOCK;
        synchronized (object) {
            Iterator<SessionState> previousStates = sessionRecord.getPreviousSessionStates().iterator();
            LinkedList<Exception> exceptions = new LinkedList<Exception>();
            try {
                SessionState sessionState = new SessionState(sessionRecord.getSessionState());
                byte[] plaintext = this.decrypt(sessionState, ciphertext);
                sessionRecord.setState(sessionState);
                return plaintext;
            }
            catch (InvalidMessageException e) {
                exceptions.add(e);
                while (previousStates.hasNext()) {
                    try {
                        SessionState promotedState = new SessionState(previousStates.next());
                        byte[] plaintext = this.decrypt(promotedState, ciphertext);
                        previousStates.remove();
                        sessionRecord.promoteState(promotedState);
                        return plaintext;
                    }
                    catch (InvalidMessageException e2) {
                        exceptions.add(e2);
                    }
                }
                throw new InvalidMessageException("No valid sessions.", exceptions);
            }
        }
    }

    private byte[] decrypt(SessionState sessionState, SignalMessage ciphertextMessage) throws InvalidMessageException, DuplicateMessageException, LegacyMessageException {
        if (!sessionState.hasSenderChain()) {
            throw new InvalidMessageException("Uninitialized session!");
        }
        if (ciphertextMessage.getMessageVersion() != sessionState.getSessionVersion()) {
            throw new InvalidMessageException(String.format("Message version %d, but session version %d", ciphertextMessage.getMessageVersion(), sessionState.getSessionVersion()));
        }
        int messageVersion = ciphertextMessage.getMessageVersion();
        ECPublicKey theirEphemeral = ciphertextMessage.getSenderRatchetKey();
        int counter = ciphertextMessage.getCounter();
        ChainKey chainKey = this.getOrCreateChainKey(sessionState, theirEphemeral);
        MessageKeys messageKeys = this.getOrCreateMessageKeys(sessionState, theirEphemeral, chainKey, counter);
        ciphertextMessage.verifyMac(messageVersion, sessionState.getRemoteIdentityKey(), sessionState.getLocalIdentityKey(), messageKeys.getMacKey());
        byte[] plaintext = this.getPlaintext(messageVersion, messageKeys, ciphertextMessage.getBody());
        sessionState.clearUnacknowledgedPreKeyMessage();
        return plaintext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRemoteRegistrationId() {
        Object object = SESSION_LOCK;
        synchronized (object) {
            SessionRecord record = this.sessionStore.loadSession(this.remoteAddress);
            return record.getSessionState().getRemoteRegistrationId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSessionVersion() {
        Object object = SESSION_LOCK;
        synchronized (object) {
            if (!this.sessionStore.containsSession(this.remoteAddress)) {
                throw new IllegalStateException(String.format("No session for (%s)!", this.remoteAddress));
            }
            SessionRecord record = this.sessionStore.loadSession(this.remoteAddress);
            return record.getSessionState().getSessionVersion();
        }
    }

    private ChainKey getOrCreateChainKey(SessionState sessionState, ECPublicKey theirEphemeral) throws InvalidMessageException {
        try {
            if (sessionState.hasReceiverChain(theirEphemeral)) {
                return sessionState.getReceiverChainKey(theirEphemeral);
            }
            RootKey rootKey = sessionState.getRootKey();
            ECKeyPair ourEphemeral = sessionState.getSenderRatchetKeyPair();
            Pair<RootKey, ChainKey> receiverChain = rootKey.createChain(theirEphemeral, ourEphemeral);
            ECKeyPair ourNewEphemeral = Curve.generateKeyPair();
            Pair<RootKey, ChainKey> senderChain = receiverChain.first().createChain(theirEphemeral, ourNewEphemeral);
            sessionState.setRootKey(senderChain.first());
            sessionState.addReceiverChain(theirEphemeral, receiverChain.second());
            sessionState.setPreviousCounter(Math.max(sessionState.getSenderChainKey().getIndex() - 1, 0));
            sessionState.setSenderChain(ourNewEphemeral, senderChain.second());
            return receiverChain.second();
        }
        catch (InvalidKeyException e) {
            throw new InvalidMessageException(e);
        }
    }

    private MessageKeys getOrCreateMessageKeys(SessionState sessionState, ECPublicKey theirEphemeral, ChainKey chainKey, int counter) throws InvalidMessageException, DuplicateMessageException {
        if (chainKey.getIndex() > counter) {
            if (sessionState.hasMessageKeys(theirEphemeral, counter)) {
                return sessionState.removeMessageKeys(theirEphemeral, counter);
            }
            throw new DuplicateMessageException("Received message with old counter: " + chainKey.getIndex() + " , " + counter);
        }
        if (counter - chainKey.getIndex() > 2000) {
            throw new InvalidMessageException("Over 2000 messages into the future!");
        }
        while (chainKey.getIndex() < counter) {
            MessageKeys messageKeys = chainKey.getMessageKeys();
            sessionState.setMessageKeys(theirEphemeral, messageKeys);
            chainKey = chainKey.getNextChainKey();
        }
        sessionState.setReceiverChainKey(theirEphemeral, chainKey.getNextChainKey());
        return chainKey.getMessageKeys();
    }

    private byte[] getCiphertext(int version, MessageKeys messageKeys, byte[] plaintext) {
        try {
            Cipher cipher = version >= 3 ? this.getCipher(1, messageKeys.getCipherKey(), messageKeys.getIv()) : this.getCipher(1, messageKeys.getCipherKey(), messageKeys.getCounter());
            return cipher.doFinal(plaintext);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new AssertionError((Object)e);
        }
    }

    private byte[] getPlaintext(int version, MessageKeys messageKeys, byte[] cipherText) throws InvalidMessageException {
        try {
            Cipher cipher = version >= 3 ? this.getCipher(2, messageKeys.getCipherKey(), messageKeys.getIv()) : this.getCipher(2, messageKeys.getCipherKey(), messageKeys.getCounter());
            return cipher.doFinal(cipherText);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new InvalidMessageException(e);
        }
    }

    private Cipher getCipher(int mode, SecretKeySpec key, int counter) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
            byte[] ivBytes = new byte[16];
            ByteUtil.intToByteArray(ivBytes, 0, counter);
            IvParameterSpec iv = new IvParameterSpec(ivBytes);
            cipher.init(mode, (Key)key, iv);
            return cipher;
        }
        catch (InvalidAlgorithmParameterException | java.security.InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new AssertionError((Object)e);
        }
    }

    private Cipher getCipher(int mode, SecretKeySpec key, IvParameterSpec iv) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(mode, (Key)key, iv);
            return cipher;
        }
        catch (InvalidAlgorithmParameterException | java.security.InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static class NullDecryptionCallback
    implements DecryptionCallback {
        private NullDecryptionCallback() {
        }

        @Override
        public void handlePlaintext(byte[] plaintext) {
        }
    }
}

