/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.devices;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.whispersystems.libsignal.devices.DeviceConsistencyCommitment;
import org.whispersystems.libsignal.devices.DeviceConsistencySignature;
import org.whispersystems.libsignal.util.ByteArrayComparator;
import org.whispersystems.libsignal.util.ByteUtil;

public class DeviceConsistencyCodeGenerator {
    private static final int CODE_VERSION = 0;

    public static String generateFor(DeviceConsistencyCommitment commitment, List<DeviceConsistencySignature> signatures) {
        try {
            ArrayList<DeviceConsistencySignature> sortedSignatures = new ArrayList<DeviceConsistencySignature>(signatures);
            Collections.sort(sortedSignatures, new SignatureComparator());
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-512");
            messageDigest.update(ByteUtil.shortToByteArray(0));
            messageDigest.update(commitment.toByteArray());
            for (DeviceConsistencySignature signature : sortedSignatures) {
                messageDigest.update(signature.getVrfOutput());
            }
            byte[] hash = messageDigest.digest();
            String digits = DeviceConsistencyCodeGenerator.getEncodedChunk(hash, 0) + DeviceConsistencyCodeGenerator.getEncodedChunk(hash, 5);
            return digits.substring(0, 6);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static String getEncodedChunk(byte[] hash, int offset) {
        long chunk = ByteUtil.byteArray5ToLong(hash, offset) % 100000L;
        return String.format("%05d", chunk);
    }

    private static class SignatureComparator
    extends ByteArrayComparator
    implements Comparator<DeviceConsistencySignature> {
        private SignatureComparator() {
        }

        @Override
        public int compare(DeviceConsistencySignature first, DeviceConsistencySignature second) {
            return this.compare(first.getSignature(), second.getSignature());
        }
    }
}

