/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.fingerprint;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.whispersystems.libsignal.IdentityKey;
import org.whispersystems.libsignal.fingerprint.DisplayableFingerprint;
import org.whispersystems.libsignal.fingerprint.Fingerprint;
import org.whispersystems.libsignal.fingerprint.FingerprintGenerator;
import org.whispersystems.libsignal.fingerprint.ScannableFingerprint;
import org.whispersystems.libsignal.util.ByteUtil;

public class NumericFingerprintGenerator
implements FingerprintGenerator {
    private static final int VERSION = 0;
    private final long iterations;

    public NumericFingerprintGenerator(long iterations) {
        this.iterations = iterations;
    }

    @Override
    public Fingerprint createFor(String localStableIdentifier, IdentityKey localIdentityKey, String remoteStableIdentifier, IdentityKey remoteIdentityKey) {
        DisplayableFingerprint displayableFingerprint = new DisplayableFingerprint(this.getDisplayStringFor(localStableIdentifier, localIdentityKey), this.getDisplayStringFor(remoteStableIdentifier, remoteIdentityKey));
        ScannableFingerprint scannableFingerprint = new ScannableFingerprint(0, localStableIdentifier, localIdentityKey, remoteStableIdentifier, remoteIdentityKey);
        return new Fingerprint(displayableFingerprint, scannableFingerprint);
    }

    private String getDisplayStringFor(String stableIdentifier, IdentityKey identityKey) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-512");
            byte[] publicKey = identityKey.getPublicKey().serialize();
            byte[] hash = ByteUtil.combine(ByteUtil.shortToByteArray(0), publicKey, stableIdentifier.getBytes());
            int i = 0;
            while ((long)i < this.iterations) {
                digest.update(hash);
                hash = digest.digest(publicKey);
                ++i;
            }
            return this.getEncodedChunk(hash, 0) + this.getEncodedChunk(hash, 5) + this.getEncodedChunk(hash, 10) + this.getEncodedChunk(hash, 15) + this.getEncodedChunk(hash, 20) + this.getEncodedChunk(hash, 25);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    private String getEncodedChunk(byte[] hash, int offset) {
        long chunk = ByteUtil.byteArray5ToLong(hash, offset) % 100000L;
        return String.format("%05d", chunk);
    }
}

