/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.fingerprint;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.security.MessageDigest;
import org.whispersystems.libsignal.IdentityKey;
import org.whispersystems.libsignal.fingerprint.FingerprintIdentifierMismatchException;
import org.whispersystems.libsignal.fingerprint.FingerprintParsingException;
import org.whispersystems.libsignal.fingerprint.FingerprintProtos;
import org.whispersystems.libsignal.fingerprint.FingerprintVersionMismatchException;

public class ScannableFingerprint {
    private final FingerprintProtos.CombinedFingerprint combinedFingerprint;

    public ScannableFingerprint(int version, String localStableIdentifier, IdentityKey localIdentityKey, String remoteStableIdentifier, IdentityKey remoteIdentityKey) {
        this.combinedFingerprint = FingerprintProtos.CombinedFingerprint.newBuilder().setVersion(version).setLocalFingerprint(FingerprintProtos.FingerprintData.newBuilder().setIdentifier(ByteString.copyFrom((byte[])localStableIdentifier.getBytes())).setPublicKey(ByteString.copyFrom((byte[])localIdentityKey.serialize()))).setRemoteFingerprint(FingerprintProtos.FingerprintData.newBuilder().setIdentifier(ByteString.copyFrom((byte[])remoteStableIdentifier.getBytes())).setPublicKey(ByteString.copyFrom((byte[])remoteIdentityKey.serialize()))).build();
    }

    public byte[] getSerialized() {
        return this.combinedFingerprint.toByteArray();
    }

    public boolean compareTo(byte[] scannedFingerprintData) throws FingerprintVersionMismatchException, FingerprintIdentifierMismatchException, FingerprintParsingException {
        try {
            FingerprintProtos.CombinedFingerprint scannedFingerprint = FingerprintProtos.CombinedFingerprint.parseFrom(scannedFingerprintData);
            if (!(scannedFingerprint.hasRemoteFingerprint() && scannedFingerprint.hasLocalFingerprint() && scannedFingerprint.hasVersion() && scannedFingerprint.getVersion() == this.combinedFingerprint.getVersion())) {
                throw new FingerprintVersionMismatchException();
            }
            if (!this.combinedFingerprint.getLocalFingerprint().getIdentifier().equals((Object)scannedFingerprint.getRemoteFingerprint().getIdentifier()) || !this.combinedFingerprint.getRemoteFingerprint().getIdentifier().equals((Object)scannedFingerprint.getLocalFingerprint().getIdentifier())) {
                throw new FingerprintIdentifierMismatchException(new String(this.combinedFingerprint.getLocalFingerprint().getIdentifier().toByteArray()), new String(this.combinedFingerprint.getRemoteFingerprint().getIdentifier().toByteArray()), new String(scannedFingerprint.getLocalFingerprint().getIdentifier().toByteArray()), new String(scannedFingerprint.getRemoteFingerprint().getIdentifier().toByteArray()));
            }
            return MessageDigest.isEqual(this.combinedFingerprint.getLocalFingerprint().toByteArray(), scannedFingerprint.getRemoteFingerprint().toByteArray()) && MessageDigest.isEqual(this.combinedFingerprint.getRemoteFingerprint().toByteArray(), scannedFingerprint.getLocalFingerprint().toByteArray());
        }
        catch (InvalidProtocolBufferException e) {
            throw new FingerprintParsingException((Exception)((Object)e));
        }
    }
}

