/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.state.impl;

import java.util.HashMap;
import java.util.Map;
import org.whispersystems.libsignal.IdentityKey;
import org.whispersystems.libsignal.IdentityKeyPair;
import org.whispersystems.libsignal.SignalProtocolAddress;
import org.whispersystems.libsignal.state.IdentityKeyStore;

public class InMemoryIdentityKeyStore
implements IdentityKeyStore {
    private final Map<SignalProtocolAddress, IdentityKey> trustedKeys = new HashMap<SignalProtocolAddress, IdentityKey>();
    private final IdentityKeyPair identityKeyPair;
    private final int localRegistrationId;

    public InMemoryIdentityKeyStore(IdentityKeyPair identityKeyPair, int localRegistrationId) {
        this.identityKeyPair = identityKeyPair;
        this.localRegistrationId = localRegistrationId;
    }

    @Override
    public IdentityKeyPair getIdentityKeyPair() {
        return this.identityKeyPair;
    }

    @Override
    public int getLocalRegistrationId() {
        return this.localRegistrationId;
    }

    @Override
    public void saveIdentity(SignalProtocolAddress address, IdentityKey identityKey) {
        this.trustedKeys.put(address, identityKey);
    }

    @Override
    public boolean isTrustedIdentity(SignalProtocolAddress address, IdentityKey identityKey) {
        IdentityKey trusted = this.trustedKeys.get(address);
        return trusted == null || trusted.equals(identityKey);
    }
}

