/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.state.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.whispersystems.libsignal.SignalProtocolAddress;
import org.whispersystems.libsignal.state.SessionRecord;
import org.whispersystems.libsignal.state.SessionStore;

public class InMemorySessionStore
implements SessionStore {
    private Map<SignalProtocolAddress, byte[]> sessions = new HashMap<SignalProtocolAddress, byte[]>();

    @Override
    public synchronized SessionRecord loadSession(SignalProtocolAddress remoteAddress) {
        try {
            if (this.containsSession(remoteAddress)) {
                return new SessionRecord(this.sessions.get(remoteAddress));
            }
            return new SessionRecord();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public synchronized List<Integer> getSubDeviceSessions(String name) {
        LinkedList<Integer> deviceIds = new LinkedList<Integer>();
        for (SignalProtocolAddress key : this.sessions.keySet()) {
            if (!key.getName().equals(name) || key.getDeviceId() == 1) continue;
            deviceIds.add(key.getDeviceId());
        }
        return deviceIds;
    }

    @Override
    public synchronized void storeSession(SignalProtocolAddress address, SessionRecord record) {
        this.sessions.put(address, record.serialize());
    }

    @Override
    public synchronized boolean containsSession(SignalProtocolAddress address) {
        return this.sessions.containsKey(address);
    }

    @Override
    public synchronized void deleteSession(SignalProtocolAddress address) {
        this.sessions.remove(address);
    }

    @Override
    public synchronized void deleteAllSessions(String name) {
        for (SignalProtocolAddress key : this.sessions.keySet()) {
            if (!key.getName().equals(name)) continue;
            this.sessions.remove(key);
        }
    }
}

