/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.state.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.whispersystems.libsignal.InvalidKeyIdException;
import org.whispersystems.libsignal.state.SignedPreKeyRecord;
import org.whispersystems.libsignal.state.SignedPreKeyStore;

public class InMemorySignedPreKeyStore
implements SignedPreKeyStore {
    private final Map<Integer, byte[]> store = new HashMap<Integer, byte[]>();

    @Override
    public SignedPreKeyRecord loadSignedPreKey(int signedPreKeyId) throws InvalidKeyIdException {
        try {
            if (!this.store.containsKey(signedPreKeyId)) {
                throw new InvalidKeyIdException("No such signedprekeyrecord! " + signedPreKeyId);
            }
            return new SignedPreKeyRecord(this.store.get(signedPreKeyId));
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public List<SignedPreKeyRecord> loadSignedPreKeys() {
        try {
            LinkedList<SignedPreKeyRecord> results = new LinkedList<SignedPreKeyRecord>();
            for (byte[] serialized : this.store.values()) {
                results.add(new SignedPreKeyRecord(serialized));
            }
            return results;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void storeSignedPreKey(int signedPreKeyId, SignedPreKeyRecord record) {
        this.store.put(signedPreKeyId, record.serialize());
    }

    @Override
    public boolean containsSignedPreKey(int signedPreKeyId) {
        return this.store.containsKey(signedPreKeyId);
    }

    @Override
    public void removeSignedPreKey(int signedPreKeyId) {
        this.store.remove(signedPreKeyId);
    }
}

