/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.maven.plugin.report;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.whitesource.agent.api.dispatch.ReportResult;

public final class ReportRenderer {
    private static final String ELEMENT_REPORT = "report";
    private static final String ELEMENT_LICENSE_HISTOGRAM = "LicenseHistogram";
    private static final String ELEMENT_LICENSE = "license";
    private static final String ELEMENT_NAME = "name";
    private static final String ELEMENT_COUNT = "count";
    private static final String ELEMENT_ALERTS = "Alerts";
    private static final String ELEMENT_NEWER_VERSION = "newerVersions";
    private static final String REPORT_NAME = "whitesource-report.xml";
    private static final String XML_FILE_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n";
    private static final String LOG_SEPERATOR = "                                                   ";
    private static final int LICENSE_NAME_LENGTH = 40;

    public static void renderToXML(File outputDirectory, ReportResult result) throws IOException {
        File report = new File(outputDirectory, REPORT_NAME);
        if (report != null) {
            report.getParentFile().mkdirs();
            PrintWriter writer = new PrintWriter(report);
            PrettyPrintXMLWriter prettyWriter = new PrettyPrintXMLWriter(writer);
            prettyWriter.writeMarkup(XML_FILE_HEADER);
            prettyWriter.startElement(ELEMENT_REPORT);
            prettyWriter.startElement(ELEMENT_LICENSE_HISTOGRAM);
            TreeMap sortedHistogram = new TreeMap(result.getLicenseDistribution());
            for (Map.Entry entry : sortedHistogram.entrySet()) {
                prettyWriter.startElement(ELEMENT_LICENSE);
                prettyWriter.startElement(ELEMENT_NAME);
                prettyWriter.writeText((String)entry.getKey());
                prettyWriter.endElement();
                prettyWriter.startElement(ELEMENT_COUNT);
                prettyWriter.writeText(String.valueOf(entry.getValue()));
                prettyWriter.endElement();
                prettyWriter.endElement();
            }
            prettyWriter.endElement();
            prettyWriter.startElement(ELEMENT_ALERTS);
            int numOfNewerVersions = result.getNumOfNewerVersions();
            if (numOfNewerVersions > 0) {
                prettyWriter.startElement(ELEMENT_NEWER_VERSION);
                prettyWriter.writeText(String.valueOf(numOfNewerVersions));
                prettyWriter.endElement();
            }
            prettyWriter.endElement();
            prettyWriter.endElement();
            writer.close();
        }
    }

    public static void renderToLog(ReportResult result, Log log) {
        log.info((CharSequence)"");
        Map licenceDistribution = result.getLicenseDistribution();
        if (licenceDistribution.isEmpty()) {
            log.info((CharSequence)"No results found");
        } else {
            log.info((CharSequence)"White Source License Report:");
            log.info((CharSequence)"");
            TreeMap sortedHistogram = new TreeMap(result.getLicenseDistribution());
            for (Map.Entry entry : sortedHistogram.entrySet()) {
                log.info((CharSequence)ReportRenderer.formatLicenseResult((String)entry.getKey(), (Integer)entry.getValue()));
            }
            int numOfNewerVersions = result.getNumOfNewerVersions();
            if (numOfNewerVersions > 0) {
                log.info((CharSequence)"");
                log.info((CharSequence)MessageFormat.format("Found {0} libraries that have newer versions.", numOfNewerVersions));
            }
            log.info((CharSequence)"");
            log.info((CharSequence)"For more information visit www.whitesourcesoftware.com");
            log.info((CharSequence)"");
        }
    }

    private static String formatLicenseResult(String license, Integer appearances) {
        String formattedLicense = license;
        if (formattedLicense.length() > 40) {
            formattedLicense = formattedLicense.substring(0, 40) + "..";
        }
        StringBuilder sb = new StringBuilder(LOG_SEPERATOR);
        sb.replace(0, formattedLicense.length(), formattedLicense + " ");
        String alignString = "  ";
        if (appearances > 9) {
            alignString = " ";
            if (appearances > 99) {
                alignString = "";
            }
        }
        sb.append(alignString + appearances);
        return sb.toString();
    }

    private ReportRenderer() {
    }
}

