/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.maven.plugin.update;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonatype.aether.util.ChecksumUtils;
import org.whitesource.agent.api.dispatch.UpdateInventoryRequest;
import org.whitesource.agent.api.dispatch.UpdateInventoryResult;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.api.model.Coordinates;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.api.model.ExclusionInfo;
import org.whitesource.agent.maven.plugin.WssServiceProvider;
import org.whitesource.agent.maven.plugin.update.Updater;
import org.whitesource.api.client.WssServiceException;

public class UpdaterImpl
implements Updater {
    private Log log;
    private Properties properties;
    private String orgToken;
    private Collection<MavenProject> projects;

    public UpdaterImpl(Properties properties, String orgToken, Collection<MavenProject> projects) {
        this.properties = properties;
        this.orgToken = orgToken;
        this.projects = projects;
    }

    @Override
    public UpdateInventoryResult update() throws MojoExecutionException {
        UpdateInventoryResult result = null;
        Collection<AgentProjectInfo> projectInfos = this.setProjects(this.projects);
        UpdateInventoryRequest request = WssServiceProvider.instance().requestFactory().newUpdateInventoryRequest(this.orgToken, projectInfos);
        this.logDebug("Request created successfully");
        try {
            result = WssServiceProvider.instance().provider().updateInventory(request);
        }
        catch (WssServiceException e) {
            throw new MojoExecutionException("Error updating inventory", (Exception)((Object)e));
        }
        return result;
    }

    @Override
    public void setLog(Log log) {
        this.log = log;
    }

    private Collection<AgentProjectInfo> setProjects(Collection<MavenProject> projects) throws MojoExecutionException {
        ArrayList<AgentProjectInfo> projectInfos = new ArrayList<AgentProjectInfo>();
        for (MavenProject project : projects) {
            projectInfos.add(this.processProject(project));
        }
        return projectInfos;
    }

    private AgentProjectInfo processProject(MavenProject mavenProject) {
        this.logDebug("Found project " + mavenProject.getArtifactId());
        AgentProjectInfo projectInfo = new AgentProjectInfo();
        this.populateProjectToken(projectInfo, mavenProject);
        this.populateCoordinates(projectInfo, mavenProject);
        this.populateDependencies(projectInfo, mavenProject);
        return projectInfo;
    }

    private void populateProjectToken(AgentProjectInfo projectInfo, MavenProject project) {
        Xpp3Dom projectTokenParameter;
        Xpp3Dom configuration;
        Plugin plugin = project.getPlugin("org.whitesource:whitesource-maven-plugin");
        if (plugin != null && (configuration = (Xpp3Dom)plugin.getConfiguration()) != null && (projectTokenParameter = configuration.getChild("projectToken")) != null) {
            projectInfo.setProjectToken(projectTokenParameter.getValue());
        }
    }

    private void populateCoordinates(AgentProjectInfo projectInfo, MavenProject project) {
        projectInfo.setCoordinates(this.extractCoordinates(project));
        MavenProject parent = project.getParent();
        if (parent != null) {
            projectInfo.setParentCoordinates(this.extractCoordinates(parent));
        }
    }

    private void populateDependencies(AgentProjectInfo projectInfo, MavenProject project) {
        Collection dependencyInfos = projectInfo.getDependencies();
        Map<Dependency, Artifact> lut = this.createLookupTable(project);
        for (Dependency dependency : project.getDependencies()) {
            String sha1 = null;
            Artifact artifact = lut.get(dependency);
            if (artifact != null) {
                sha1 = this.calculateSha1(artifact);
            }
            DependencyInfo dependencyInfo = this.getDependencyInfo(dependency);
            dependencyInfo.setSha1(sha1);
            dependencyInfos.add(dependencyInfo);
        }
    }

    private Map<Dependency, Artifact> createLookupTable(MavenProject project) {
        HashMap<Dependency, Artifact> lut = new HashMap<Dependency, Artifact>();
        for (Dependency dependency : project.getDependencies()) {
            for (Artifact dependencyArtifact : project.getDependencyArtifacts()) {
                if (!this.match(dependency, dependencyArtifact)) continue;
                lut.put(dependency, dependencyArtifact);
            }
        }
        return lut;
    }

    private boolean match(Dependency dependency, Artifact artifact) {
        boolean match;
        boolean bl = match = dependency.getGroupId().equals(artifact.getGroupId()) && dependency.getArtifactId().equals(artifact.getArtifactId()) && dependency.getVersion().equals(artifact.getVersion());
        if (match) {
            match = dependency.getClassifier() == null ? artifact.getClassifier() == null : dependency.getClassifier().equals(artifact.getClassifier());
        }
        if (match) {
            String type = artifact.getType();
            match = dependency.getType() == null ? type == null || type.equals("jar") : dependency.getType().equals(type);
        }
        return match;
    }

    private String calculateSha1(Artifact artifact) {
        String sha1 = null;
        File file = artifact.getFile();
        if (file != null) {
            try {
                Map calcMap = ChecksumUtils.calc((File)file, Arrays.asList("SHA-1"));
                sha1 = (String)calcMap.get("SHA-1");
            }
            catch (IOException e) {
                this.logDebug("Error calculating SHA-1");
            }
        }
        return sha1;
    }

    private DependencyInfo getDependencyInfo(Dependency dependency) {
        DependencyInfo info = new DependencyInfo();
        info.setGroupId(dependency.getGroupId());
        info.setArtifactId(dependency.getArtifactId());
        info.setVersion(dependency.getVersion());
        info.setScope(dependency.getScope());
        info.setClassifier(dependency.getClassifier());
        info.setOptional(dependency.isOptional());
        info.setType(dependency.getType());
        info.setSystemPath(dependency.getSystemPath());
        Collection exclusions = info.getExclusions();
        for (Exclusion exclusion : dependency.getExclusions()) {
            exclusions.add(new ExclusionInfo(exclusion.getGroupId(), exclusion.getArtifactId()));
        }
        return info;
    }

    private Coordinates extractCoordinates(MavenProject mavenProject) {
        return new Coordinates(mavenProject.getGroupId(), mavenProject.getArtifactId(), mavenProject.getVersion());
    }

    private void logDebug(String message) {
        if (this.log != null) {
            this.log.debug((CharSequence)message);
        }
    }
}

