/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.maven;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.whitesource.agent.api.ChecksumUtils;
import org.whitesource.agent.api.dispatch.CheckPoliciesResult;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.api.model.Coordinates;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.api.model.ExclusionInfo;
import org.whitesource.agent.report.PolicyCheckReport;
import org.whitesource.maven.WhitesourceMojo;
import org.whitesource.maven.utils.dependencies.AetherArtifact;
import org.whitesource.maven.utils.dependencies.AetherDependency;
import org.whitesource.maven.utils.dependencies.AetherDependencyNode;
import org.whitesource.maven.utils.dependencies.AetherExclusion;
import org.whitesource.maven.utils.dependencies.DependencyGraphFactory;

public abstract class AgentMojo
extends WhitesourceMojo {
    public static final String POM = "pom";
    public static final String TYPE = "type";
    public static final String SCOPE_TEST = "test";
    public static final String SCOPE_PROVIDED = "provided";
    @Parameter(alias="orgToken", property="org.whitesource.orgToken", required=true)
    protected String orgToken;
    @Parameter(alias="product", property="org.whitesource.product", required=false)
    protected String product;
    @Parameter(alias="productVersion", property="org.whitesource.productVersion", required=false)
    protected String productVersion;
    @Parameter(alias="ignoreTestScopeDependencies", property="org.whitesource.ignoreTestScopeDependencies", required=false, defaultValue="true")
    protected boolean ignoreTestScopeDependencies;
    @Parameter(alias="outputDirectory", property="org.whitesource.outputDirectory", required=false, defaultValue="${project.reporting.outputDirectory}")
    protected File outputDirectory;
    @Parameter(alias="projectToken", property="org.whitesource.projectToken", required=false)
    protected String projectToken;
    @Parameter(alias="moduleTokens", property="org.whitesource.moduleTokens", required=false)
    protected Map<String, String> moduleTokens = new HashMap<String, String>();
    @Parameter(alias="specialModuleTokens", property="org.whitesource.specialModuleTokens", required=false)
    protected Properties specialModuleTokens = new Properties();
    @Parameter(alias="ignore", property="org.whitesource.ignore", required=false, defaultValue="false")
    protected boolean ignore;
    @Parameter(alias="includes", property="org.whitesource.includes", required=false, defaultValue="")
    protected String[] includes;
    @Parameter(alias="excludes", property="org.whitesource.excludes", required=false, defaultValue="")
    protected String[] excludes;
    @Parameter(alias="ignoredScopes", property="org.whitesource.scope", required=false)
    protected String[] ignoredScopes;
    @Parameter(alias="ignorePomModules", property="org.whitesource.ignorePomModules", required=false, defaultValue="true")
    protected boolean ignorePomModules;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    protected Collection<MavenProject> reactorProjects;
    @Parameter(alias="aggregateModules", property="org.whitesource.aggregateModules", required=false, defaultValue="false")
    protected boolean aggregateModules;
    @Parameter(alias="aggregateProjectName", property="org.whitesource.aggregateProjectName", required=false)
    protected String aggregateProjectName;
    @Parameter(alias="aggregateProjectToken", property="org.whitesource.aggregateProjectToken", required=false)
    protected String aggregateProjectToken;
    @Parameter(alias="requesterEmail", property="org.whitesource.requesterEmail", required=false)
    protected String requesterEmail;

    protected AgentMojo() {
        if (this.ignoredScopes == null) {
            this.ignoredScopes = new String[2];
            this.ignoredScopes[0] = SCOPE_TEST;
            this.ignoredScopes[1] = SCOPE_PROVIDED;
        }
    }

    protected DependencyInfo getDependencyInfo(Dependency dependency) {
        DependencyInfo info = new DependencyInfo();
        info.setGroupId(dependency.getGroupId());
        info.setArtifactId(dependency.getArtifactId());
        info.setVersion(dependency.getVersion());
        info.setScope(dependency.getScope());
        info.setClassifier(dependency.getClassifier());
        info.setOptional(dependency.isOptional());
        info.setType(dependency.getType());
        info.setSystemPath(dependency.getSystemPath());
        Collection exclusions = info.getExclusions();
        for (Exclusion exclusion : dependency.getExclusions()) {
            exclusions.add(new ExclusionInfo(exclusion.getArtifactId(), exclusion.getGroupId()));
        }
        return info;
    }

    private DependencyInfo getDependencyInfo(AetherDependencyNode dependencyNode) {
        DependencyInfo info = new DependencyInfo();
        AetherDependency dependency = dependencyNode.getDependency();
        AetherArtifact artifact = dependency.getArtifact();
        info.setGroupId(artifact.getGroupId());
        info.setArtifactId(artifact.getArtifactId());
        info.setVersion(artifact.getVersion());
        info.setScope(dependency.getScope());
        info.setClassifier(artifact.getClassifier());
        info.setOptional(dependency.isOptional());
        info.setType(artifact.getProperty(TYPE, ""));
        File artifactFile = artifact.getFile();
        if (artifactFile != null && artifactFile.exists()) {
            try {
                info.setSystemPath(artifactFile.getAbsolutePath());
                info.setSha1(ChecksumUtils.calculateSHA1((File)artifactFile));
            }
            catch (IOException e) {
                this.debug("Error calculating SHA-1 for " + dependency.toString());
            }
        }
        for (AetherExclusion exclusion : dependency.getExclusions()) {
            info.getExclusions().add(new ExclusionInfo(exclusion.getArtifactId(), exclusion.getGroupId()));
        }
        for (AetherDependencyNode child : dependencyNode.getChildren()) {
            info.getChildren().add(this.getDependencyInfo(child));
        }
        return info;
    }

    protected void debugProjectInfos(Collection<AgentProjectInfo> projectInfos) {
        this.debug("----------------- dumping projectInfos -----------------");
        this.debug("Total Number of Projects : " + projectInfos.size());
        for (AgentProjectInfo projectInfo : projectInfos) {
            this.debug("Project Coordinates: " + projectInfo.getCoordinates().toString());
            this.debug("Project Parent Coordinates: " + (projectInfo.getParentCoordinates() == null ? "" : projectInfo.getParentCoordinates().toString()));
            this.debug("Project Token: " + projectInfo.getProjectToken());
            this.debug("Total Number of Dependencies: " + projectInfo.getDependencies().size());
            for (DependencyInfo info : projectInfo.getDependencies()) {
                this.debug(info.toString() + " SHA-1: " + info.getSha1());
            }
        }
        this.debug("----------------- dump finished -----------------");
    }

    protected AgentProjectInfo processProject(MavenProject project) throws MojoExecutionException {
        long startTime = System.currentTimeMillis();
        this.info("Processing " + project.getId());
        AgentProjectInfo projectInfo = new AgentProjectInfo();
        if (project.equals((Object)this.mavenProject)) {
            projectInfo.setProjectToken(this.projectToken);
        } else {
            projectInfo.setProjectToken(this.moduleTokens.get(project.getArtifactId()));
        }
        projectInfo.setCoordinates(this.extractCoordinates(project));
        if (project.hasParent()) {
            projectInfo.setParentCoordinates(this.extractCoordinates(project.getParent()));
        }
        try {
            projectInfo.getDependencies().addAll(this.collectDependencyStructure(project));
        }
        catch (DependencyResolutionException e) {
            this.debug("Error resolving project dependencies, fallback to direct dependencies only", e);
            projectInfo.getDependencies().clear();
            projectInfo.getDependencies().addAll(this.collectDirectDependencies(project));
        }
        this.debug("Total Processing Time = " + (System.currentTimeMillis() - startTime) + " [msec]");
        return projectInfo;
    }

    protected Collection<DependencyInfo> collectDirectDependencies(MavenProject project) {
        ArrayList<DependencyInfo> dependencyInfos = new ArrayList<DependencyInfo>();
        Map<Dependency, Artifact> lut = this.createLookupTable(project);
        for (Dependency dependency : project.getDependencies()) {
            File artifactFile;
            if (this.ignoreTestScopeDependencies && SCOPE_TEST.equals(dependency.getScope())) continue;
            DependencyInfo dependencyInfo = this.getDependencyInfo(dependency);
            Artifact artifact = lut.get(dependency);
            if (artifact != null && (artifactFile = artifact.getFile()) != null && artifactFile.exists()) {
                try {
                    dependencyInfo.setSha1(ChecksumUtils.calculateSHA1((File)artifactFile));
                }
                catch (IOException e) {
                    this.debug("Error calculating SHA-1 for " + artifact.getId());
                }
            }
            dependencyInfos.add(dependencyInfo);
        }
        return dependencyInfos;
    }

    protected Collection<DependencyInfo> collectDependencyStructure(MavenProject project) throws DependencyResolutionException {
        AetherDependencyNode rootNode = DependencyGraphFactory.getAetherDependencyGraphRootNode((MavenProject)project, (ProjectDependenciesResolver)this.projectDependenciesResolver, (MavenSession)this.session);
        ArrayList<DependencyInfo> dependencyInfos = new ArrayList<DependencyInfo>();
        for (AetherDependencyNode dependencyNode : rootNode.getChildren()) {
            String scope = dependencyNode.getDependency().getScope();
            if (!StringUtils.isBlank((String)scope) && this.shouldIgnore(scope)) continue;
            DependencyInfo info = this.getDependencyInfo(dependencyNode);
            dependencyInfos.add(info);
        }
        this.debug(MessageFormat.format("*** Printing Graph Result for {0} ***", project.getName()));
        for (DependencyInfo dependencyInfo : dependencyInfos) {
            this.debugPrintChildren(dependencyInfo, "");
        }
        return dependencyInfos;
    }

    private void debugPrintChildren(DependencyInfo info, String prefix) {
        this.debug(prefix + info.getGroupId() + ":" + info.getArtifactId() + ":" + info.getVersion() + ":" + info.getScope());
        for (DependencyInfo child : info.getChildren()) {
            this.debugPrintChildren(child, prefix + "   ");
        }
    }

    protected Coordinates extractCoordinates(MavenProject mavenProject) {
        return new Coordinates(mavenProject.getGroupId(), mavenProject.getArtifactId(), mavenProject.getVersion());
    }

    protected Map<Dependency, Artifact> createLookupTable(MavenProject project) {
        HashMap<Dependency, Artifact> lut = new HashMap<Dependency, Artifact>();
        for (Dependency dependency : project.getDependencies()) {
            for (Artifact dependencyArtifact : project.getDependencyArtifacts()) {
                if (!this.match(dependency, dependencyArtifact)) continue;
                lut.put(dependency, dependencyArtifact);
            }
        }
        return lut;
    }

    protected boolean matchAny(String value, String[] patterns) {
        if (value == null) {
            return false;
        }
        boolean match = false;
        for (int i = 0; i < patterns.length && !match; ++i) {
            String pattern = patterns[i];
            if (pattern == null) continue;
            String regex = pattern.replace(".", "\\.").replace("*", ".*");
            match = value.matches(regex);
        }
        return match;
    }

    protected boolean match(Dependency dependency, Artifact artifact) {
        boolean match;
        boolean bl = match = dependency.getGroupId().equals(artifact.getGroupId()) && dependency.getArtifactId().equals(artifact.getArtifactId()) && dependency.getVersion().equals(artifact.getVersion());
        if (match) {
            String artifactClassifier = artifact.getClassifier();
            match = dependency.getClassifier() == null ? artifactClassifier == null || StringUtils.isBlank((String)artifactClassifier) : dependency.getClassifier().equals(artifactClassifier);
        }
        if (match) {
            String type = artifact.getType();
            match = dependency.getType() == null ? type == null || "jar".equals(type) : dependency.getType().equals(type);
        }
        return match;
    }

    protected Collection<AgentProjectInfo> extractProjectInfos() throws MojoExecutionException {
        ArrayList<AgentProjectInfo> projectInfos = new ArrayList<AgentProjectInfo>();
        for (MavenProject project : this.reactorProjects) {
            if (!this.shouldProcess(project)) continue;
            projectInfos.add(this.processProject(project));
        }
        this.debugProjectInfos(projectInfos);
        if (this.aggregateModules) {
            HashSet<DependencyInfo> flatDependencies = new HashSet<DependencyInfo>();
            for (AgentProjectInfo projectInfo : projectInfos) {
                for (DependencyInfo dependency : projectInfo.getDependencies()) {
                    flatDependencies.add(dependency);
                    flatDependencies.addAll(this.extractChildren(dependency));
                }
            }
            projectInfos.clear();
            AgentProjectInfo aggregatingProject = new AgentProjectInfo();
            aggregatingProject.setCoordinates(this.extractCoordinates(this.mavenProject));
            aggregatingProject.setProjectToken(this.aggregateProjectToken);
            aggregatingProject.getDependencies().addAll(flatDependencies);
            if (StringUtils.isNotBlank((String)this.aggregateProjectName)) {
                aggregatingProject.getCoordinates().setArtifactId(this.aggregateProjectName);
            }
            projectInfos.add(aggregatingProject);
        }
        return projectInfos;
    }

    private Collection<DependencyInfo> extractChildren(DependencyInfo dependency) {
        ArrayList<DependencyInfo> children = new ArrayList<DependencyInfo>();
        Iterator iterator = dependency.getChildren().iterator();
        while (iterator.hasNext()) {
            DependencyInfo child = (DependencyInfo)iterator.next();
            children.add(child);
            children.addAll(this.extractChildren(child));
            iterator.remove();
        }
        return children;
    }

    protected boolean shouldProcess(MavenProject project) {
        if (project == null) {
            return false;
        }
        boolean process = true;
        if (this.ignorePomModules && POM.equals(project.getPackaging())) {
            process = false;
            this.info("Skipping " + project.getId() + " (ignorePomModules=" + String.valueOf(this.ignorePomModules) + ")");
        } else if (project.equals((Object)this.mavenProject)) {
            boolean bl = process = !this.ignore;
            if (!process) {
                this.info("Skipping " + project.getId() + " (marked as ignored)");
            }
        } else if (this.excludes.length > 0 && this.matchAny(project.getArtifactId(), this.excludes)) {
            process = false;
            this.info("Skipping " + project.getId() + " (marked as excluded)");
        } else if (this.includes.length > 0 && this.matchAny(project.getArtifactId(), this.includes)) {
            process = true;
        }
        return process;
    }

    protected void generateReport(CheckPoliciesResult result) throws MojoExecutionException {
        this.info("Generating Policy Check Report");
        try {
            PolicyCheckReport report = new PolicyCheckReport(result);
            report.generate(this.outputDirectory, false);
            report.generateJson(this.outputDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error generating report: " + e.getMessage(), (Exception)e);
        }
    }

    private boolean shouldIgnore(String scope) {
        boolean ignore = false;
        for (String ignoredScope : this.ignoredScopes) {
            if (!ignoredScope.equals(scope)) continue;
            ignore = true;
            break;
        }
        return ignore;
    }
}

