/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.maven;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.whitesource.agent.api.dispatch.CheckPoliciesResult;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.client.WssServiceException;
import org.whitesource.maven.AgentMojo;

@Mojo(name="checkPolicies", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST, aggregator=true)
public class CheckPoliciesMojo
extends AgentMojo {
    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        if (this.reactorProjects == null) {
            this.info("No Projects Found. Skipping Update");
            return;
        }
        this.init();
        Collection<AgentProjectInfo> projectInfos = this.extractProjectInfos();
        if (projectInfos == null || projectInfos.isEmpty()) {
            this.info("No open source information found.");
        } else {
            this.sendCheckPolicies(projectInfos);
        }
    }

    private void init() {
        for (Map.Entry<Object, Object> entry : this.specialModuleTokens.entrySet()) {
            this.moduleTokens.put(entry.getKey().toString(), entry.getValue().toString());
        }
        MavenProject topLevelProject = this.session.getTopLevelProject();
        if (topLevelProject != null) {
            if (StringUtils.isBlank((String)this.product)) {
                this.product = topLevelProject.getName();
            }
            if (StringUtils.isBlank((String)this.product)) {
                this.product = topLevelProject.getArtifactId();
            }
        }
    }

    private void sendCheckPolicies(Collection<AgentProjectInfo> projectInfos) throws MojoFailureException, MojoExecutionException {
        try {
            this.info("Checking Policies");
            CheckPoliciesResult result = this.service.checkPolicies(this.orgToken, this.product, this.productVersion, projectInfos);
            if (this.outputDirectory == null || !this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
                this.warn("Output directory doesn't exist. Skipping policies check report.");
            } else {
                this.generateReport(result);
            }
            if (result.hasRejections()) {
                String msg = "Some dependencies were rejected by the organization's policies.";
                throw new MojoExecutionException(msg);
            }
            this.info("All dependencies conform with the organization's policies.");
        }
        catch (WssServiceException e) {
            throw new MojoExecutionException("Error communicating with service: " + e.getMessage(), (Exception)((Object)e));
        }
    }
}

