/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.maven;

import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.whitesource.agent.client.WhitesourceService;
import org.whitesource.maven.utils.proxy.ProxySettings;
import org.whitesource.maven.utils.proxy.ProxySettingsProvider;
import org.whitesource.maven.utils.proxy.ProxySettingsProviderFactory;

public abstract class WhitesourceMojo
extends AbstractMojo {
    @Parameter(defaultValue="false")
    protected boolean failOnError;
    @Parameter(defaultValue="false")
    protected boolean skip;
    @Component
    protected MavenSession session;
    @Component
    protected MavenProject mavenProject;
    @Component(hint="default")
    protected ProjectDependenciesResolver projectDependenciesResolver;
    protected WhitesourceService service;

    public abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    public void execute() throws MojoExecutionException, MojoFailureException {
        long startTime = System.currentTimeMillis();
        if (this.skip) {
            this.info("Skipping update");
        } else {
            try {
                this.createService();
                this.doExecute();
            }
            catch (MojoExecutionException e) {
                this.handleError((Exception)((Object)e));
            }
            catch (RuntimeException e) {
                throw new MojoFailureException("Unexpected error", (Throwable)e);
            }
            finally {
                if (this.service != null) {
                    this.service.shutdown();
                }
            }
        }
        this.debug("Total execution time is " + (System.currentTimeMillis() - startTime) + " [msec]");
    }

    protected void createService() {
        String serviceUrl = this.session.getSystemProperties().getProperty("wss.url", "https://saas.whitesourcesoftware.com/agent");
        this.info("Service URL is " + serviceUrl);
        this.service = new WhitesourceService("maven-plugin", "2.2.5", serviceUrl);
        if (this.service == null) {
            this.info("Failed to initiate WhiteSource Service");
        } else {
            this.info("Initiated WhiteSource Service");
        }
        ProxySettingsProvider proxySettingsProvider = ProxySettingsProviderFactory.getProxySettingsProviderForUrl((String)serviceUrl, (MavenSession)this.session);
        if (proxySettingsProvider.isProxyConfigured()) {
            ProxySettings proxySettings = proxySettingsProvider.getProxySettings();
            this.service.getClient().setProxy(proxySettings.getHostname(), proxySettings.getPort(), proxySettings.getUsername(), proxySettings.getPassword());
        } else {
            this.info("No Proxy Settings");
        }
    }

    protected void handleError(Exception error) throws MojoFailureException {
        String message = error.getMessage();
        if (this.failOnError) {
            this.debug(message, error);
            throw new MojoFailureException(message);
        }
        this.error(message, error);
    }

    protected void debug(CharSequence content) {
        Log log = this.getLog();
        if (log != null) {
            log.debug(content);
        }
    }

    protected void debug(CharSequence content, Throwable error) {
        Log log = this.getLog();
        if (log != null) {
            log.debug(content, error);
        }
    }

    protected void info(CharSequence content) {
        Log log = this.getLog();
        if (log != null) {
            log.info(content);
        }
    }

    protected void warn(CharSequence content, Throwable error) {
        Log log = this.getLog();
        if (log != null) {
            log.debug(content, error);
            log.warn(content);
        }
    }

    protected void warn(CharSequence content) {
        Log log = this.getLog();
        if (log != null) {
            log.warn(content);
        }
    }

    protected void error(CharSequence content, Throwable error) {
        Log log = this.getLog();
        if (log != null) {
            log.debug(content, error);
            log.error(content);
        }
    }

    protected void error(CharSequence content) {
        Log log = this.getLog();
        if (log != null) {
            log.error(content);
        }
    }
}

