/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.whitesource.agent.api.model.AnalysisInputs;
import org.whitesource.agent.api.model.ChecksumType;
import org.whitesource.agent.api.model.DependencyHintsInfo;
import org.whitesource.agent.api.model.DependencyType;
import org.whitesource.agent.api.model.OSInfo;
import org.whitesource.agent.via.api.VulnerabilityAnalysisResult;

public class DependencyInfo
implements Serializable {
    private static final long serialVersionUID = -6212622409560068635L;
    private String groupId;
    private String artifactId;
    private String version;
    private String type;
    private String classifier;
    private String scope;
    private String sha1;
    private String fullHash;
    private String commentlessSha1;
    private String noNewLinesSha1;
    private String otherPlatformSha1;
    private String systemPath;
    private boolean optional;
    private Collection<DependencyInfo> children;
    private Date lastModified;
    private String filename;
    private DependencyType dependencyType;
    private DependencyHintsInfo hints;
    private Map<ChecksumType, String> checksums;
    private VulnerabilityAnalysisResult vulnerabilityAnalysisResult;
    private String commit;
    private String dependencyFile;
    private String additionalSha1;
    private String architecture;
    private String languageVersion;
    private boolean deduped;
    private OSInfo osInfo;
    private AnalysisInputs analysisInputs;

    public DependencyInfo() {
    }

    public DependencyInfo(String groupId, String artifactId, String version) {
        this();
        this.groupId = groupId;
        this.version = version;
        this.artifactId = artifactId;
    }

    public DependencyInfo(String sha1) {
        this();
        this.setSha1(sha1);
    }

    public DependencyInfo(String sha1, String fullHash) {
        this(sha1);
        this.setFullHash(fullHash);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DependencyInfo@").append(Integer.toHexString(this.hashCode())).append("[").append("groupId= ").append(this.groupId).append(",").append("artifactId= ").append(this.artifactId).append(",").append("version= ").append(this.version).append(",").append("filename= ").append(this.filename).append(",").append("dependencyType= ").append((Object)this.dependencyType).append(" ]");
        return sb.toString();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DependencyInfo)) {
            return false;
        }
        DependencyInfo that = (DependencyInfo)o;
        if (StringUtils.isNotEmpty((String)this.sha1)) {
            return this.sha1.equals(that.sha1);
        }
        if (StringUtils.isNotEmpty((String)that.sha1)) {
            return false;
        }
        if (this.optional != that.optional) {
            return false;
        }
        if (this.artifactId != null ? !this.artifactId.equals(that.artifactId) : that.artifactId != null) {
            return false;
        }
        if (this.classifier != null ? !this.classifier.equals(that.classifier) : that.classifier != null) {
            return false;
        }
        if (this.groupId != null ? !this.groupId.equals(that.groupId) : that.groupId != null) {
            return false;
        }
        if (this.scope != null ? !this.scope.equals(that.scope) : that.scope != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        if (this.filename != null ? !this.filename.equals(that.filename) : that.filename != null) {
            return false;
        }
        if (this.commit != null ? !this.commit.equals(that.commit) : that.commit != null) {
            return false;
        }
        if (this.dependencyType != null ? !this.dependencyType.equals((Object)that.dependencyType) : that.dependencyType != null) {
            return false;
        }
        if (this.systemPath != null ? !this.systemPath.equals(that.systemPath) : that.systemPath != null) {
            return false;
        }
        if (this.dependencyFile != null ? !this.dependencyFile.equals(that.dependencyFile) : that.dependencyFile != null) {
            return false;
        }
        return !(this.vulnerabilityAnalysisResult != null ? !this.vulnerabilityAnalysisResult.equals((Object)that.vulnerabilityAnalysisResult) : that.vulnerabilityAnalysisResult != null);
    }

    public int hashCode() {
        int result = 133;
        result = 23 * result + (this.groupId != null ? this.groupId.hashCode() : 0);
        result = 23 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        result = 23 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 23 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 23 * result + (this.classifier != null ? this.classifier.hashCode() : 0);
        result = 23 * result + (this.scope != null ? this.scope.hashCode() : 0);
        result = 23 * result + (this.sha1 != null ? this.sha1.hashCode() : 0);
        result = 23 * result + (this.optional ? 1 : 0);
        result = 23 * result + (this.filename != null ? this.filename.hashCode() : 0);
        result = 23 * result + (this.dependencyType != null ? this.dependencyType.hashCode() : 0);
        result = 23 * result + (this.systemPath != null ? this.systemPath.hashCode() : 0);
        result = 23 * result + (this.dependencyFile != null ? this.dependencyFile.hashCode() : 0);
        result = 23 * result + (this.vulnerabilityAnalysisResult != null ? this.vulnerabilityAnalysisResult.hashCode() : 0);
        result = 23 * result + (this.commit != null ? this.commit.hashCode() : 0);
        result = 23 * result + (this.additionalSha1 != null ? this.additionalSha1.hashCode() : 0);
        return result;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getSha1() {
        return this.sha1;
    }

    public void setSha1(String sha1) {
        this.sha1 = sha1;
        this.addChecksum(ChecksumType.SHA1, sha1);
    }

    public String getSystemPath() {
        return this.systemPath;
    }

    public void setSystemPath(String systemPath) {
        this.systemPath = systemPath;
    }

    public boolean getOptional() {
        return this.optional;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public Collection<DependencyInfo> getChildren() {
        if (this.children == null) {
            this.children = new LinkedList<DependencyInfo>();
        }
        return this.children;
    }

    public void setChildren(Collection<DependencyInfo> children) {
        this.children = children;
    }

    public void addChild(DependencyInfo child) {
        if (this.children == null) {
            this.children = new LinkedList<DependencyInfo>();
        }
        this.children.add(child);
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() != 0;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public String getCommentlessSha1() {
        return this.commentlessSha1;
    }

    public void setCommentlessSha1(String commentlessSha1) {
        this.commentlessSha1 = commentlessSha1;
        this.addChecksum(ChecksumType.SHA1_NO_COMMENTS, commentlessSha1);
    }

    public String getNoNewLinesSha1() {
        return this.noNewLinesSha1;
    }

    public void setNoNewLinesSha1(String noNewLinesSha1) {
        this.noNewLinesSha1 = noNewLinesSha1;
    }

    public String getOtherPlatformSha1() {
        return this.otherPlatformSha1;
    }

    public void setOtherPlatformSha1(String otherPlatformSha1) {
        this.otherPlatformSha1 = otherPlatformSha1;
        this.addChecksum(ChecksumType.SHA1_OTHER_PLATFORM, otherPlatformSha1);
    }

    public String getFullHash() {
        return this.fullHash;
    }

    public void setFullHash(String fullHash) {
        this.fullHash = fullHash;
        this.addChecksum(ChecksumType.SHA1_SUPER_HASH, fullHash);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public DependencyType getDependencyType() {
        return this.dependencyType;
    }

    public void setDependencyType(DependencyType dependencyType) {
        this.dependencyType = dependencyType;
    }

    public DependencyHintsInfo getHints() {
        return this.hints;
    }

    public void setHints(DependencyHintsInfo hints) {
        this.hints = hints;
    }

    public Map<ChecksumType, String> getChecksums() {
        if (this.checksums == null) {
            this.checksums = new TreeMap<ChecksumType, String>();
        }
        return this.checksums;
    }

    public void setChecksums(Map<ChecksumType, String> checksums) {
        this.checksums = checksums;
    }

    public void addChecksum(ChecksumType checksumType, String checksum) {
        if (StringUtils.isNotBlank((String)checksum)) {
            if (this.checksums == null) {
                this.checksums = new TreeMap<ChecksumType, String>();
            }
            this.checksums.put(checksumType, checksum);
        }
    }

    public boolean hasChecksum() {
        return this.checksums != null && this.checksums.size() != 0;
    }

    public VulnerabilityAnalysisResult getVulnerabilityAnalysisResult() {
        return this.vulnerabilityAnalysisResult;
    }

    public void setVulnerabilityAnalysisResult(VulnerabilityAnalysisResult vulnerabilityAnalysisResult) {
        this.vulnerabilityAnalysisResult = vulnerabilityAnalysisResult;
    }

    public String getCommit() {
        return this.commit;
    }

    public void setCommit(String commit) {
        this.commit = commit;
    }

    public String getDependencyFile() {
        return this.dependencyFile;
    }

    public void setDependencyFile(String dependencyFile) {
        this.dependencyFile = dependencyFile;
    }

    public String getAdditionalSha1() {
        return this.additionalSha1;
    }

    public void setAdditionalSha1(String additionalSha1) {
        this.additionalSha1 = additionalSha1;
        this.addChecksum(ChecksumType.ADDITIONAL_SHA1, additionalSha1);
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public String getLanguageVersion() {
        return this.languageVersion;
    }

    public void setLanguageVersion(String languageVersion) {
        this.languageVersion = languageVersion;
    }

    public boolean isDeduped() {
        return this.deduped;
    }

    public void setDeduped(boolean deduped) {
        this.deduped = deduped;
    }

    public OSInfo getOsInfo() {
        return this.osInfo;
    }

    public void setOsInfo(OSInfo osInfo) {
        this.osInfo = osInfo;
    }

    public AnalysisInputs getAnalysisInputs() {
        return this.analysisInputs;
    }

    public void setAnalysisInputs(AnalysisInputs analysisInputs) {
        this.analysisInputs = analysisInputs;
    }

    public void initAnalysisInputs() {
        if (this.analysisInputs == null) {
            this.analysisInputs = new AnalysisInputs(this.artifactId);
        }
    }

    public void initAnalysisInputs(String euaArtifactId) {
        if (this.analysisInputs == null) {
            this.analysisInputs = new AnalysisInputs(euaArtifactId);
        }
    }

    public void resetUnusedFields() {
        this.analysisInputs = null;
        if (this.checksums != null && this.checksums.size() == 0) {
            this.checksums = null;
        }
        if (this.children != null && this.children.size() == 0) {
            this.children = null;
        }
        if (this.children != null) {
            for (DependencyInfo child : this.children) {
                child.resetUnusedFields();
            }
        }
    }
}

