/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.hash;

import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.hash.FileExtensions;
import org.whitesource.agent.hash.FileHandler;
import org.whitesource.agent.hash.FileUtils;
import org.whitesource.agent.hash.HashAlgorithm;
import org.whitesource.agent.hash.HashCalculationResult;
import org.whitesource.agent.hash.HashCalculator;

public final class ChecksumUtils {
    private static final Logger logger = LoggerFactory.getLogger(ChecksumUtils.class);
    private static final int PARTIAL_SHA1_LINES = 100;
    private static final String EMPTY_FILE_SHA1 = "da39a3ee5e6b4b0d3255bfef95601890afd80709";

    private ChecksumUtils() {
    }

    public static String calculateSHA1(File resourceFile) throws IOException {
        return ChecksumUtils.calculateHash(resourceFile, HashAlgorithm.SHA1);
    }

    public static String calculateHash(File resourceFile, HashAlgorithm algorithm) throws IOException {
        return new HashCalculator().calculateHash(resourceFile, algorithm);
    }

    public static void calculateSuperHash(DependencyInfo dependencyInfo, File dependencyFile) {
        StringBuilder superHash = new StringBuilder("");
        HashCalculator superHashCalculator = new HashCalculator();
        if (dependencyFile.getName().toLowerCase().matches(FileExtensions.SOURCE_FILE_PATTERN) || dependencyFile.getName().toLowerCase().endsWith("++")) {
            try {
                HashCalculationResult superHashResult = superHashCalculator.calculateSuperHash(dependencyFile);
                if (superHashResult != null) {
                    dependencyInfo.setFullHash(superHashResult.getFullHash());
                    superHash.append(superHashResult.getFullHash());
                }
            }
            catch (IOException e) {
                logger.warn("Error calculating fullHash for {}, Error - ", (Object)dependencyFile.getName(), (Object)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String calculateOtherPlatformSha1(File file) {
        String otherPlatformSha1 = null;
        if (file.length() <= 0xA00000L) {
            File otherPlatformFile = null;
            try {
                otherPlatformFile = FileUtils.createOtherPlatformFile(file);
                if (otherPlatformFile != null && EMPTY_FILE_SHA1.equals(otherPlatformSha1 = ChecksumUtils.calculateSHA1(otherPlatformFile))) {
                    otherPlatformSha1 = null;
                }
            }
            catch (Exception exception) {
            }
            finally {
                FileHandler.deleteTempFoldersHelper(FileHandler.PATH_TO_PLATFORM_DEPENDENT_TMP_DIR);
            }
        }
        return otherPlatformSha1;
    }

    public static void calculateOtherPlatformSha1(DependencyInfo dependency, File file) {
        String otherPlatformSha1 = ChecksumUtils.calculateOtherPlatformSha1(file);
        dependency.setOtherPlatformSha1(otherPlatformSha1);
    }

    private static void deleteFile(File file) {
        if (file != null) {
            try {
                org.apache.commons.io.FileUtils.forceDelete((File)file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

