/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.reports;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.slf4j.Logger;
import org.whitesource.agent.api.model.ProjectDetails;
import org.whitesource.utils.logger.LoggerFactory;

public class ScanProjectDetailsJsonReport {
    public static final String PROJECT_TOKEN = "projectToken";
    public static final String PROJECT_NAME = "projectName";
    public static final String PROJECTS = "projects";
    private final Logger logger = LoggerFactory.getLogger(ScanProjectDetailsJsonReport.class);
    private String path;
    private String childPath;
    private Map<String, ProjectDetails> projectNamesToDetails;

    public void setPath(String path) {
        this.path = path;
    }

    public void setProjectNamesToDetails(Map<String, ProjectDetails> projectNamesToDetails) {
        this.projectNamesToDetails = projectNamesToDetails;
    }

    public void setChildPath(String childPath) {
        this.childPath = childPath;
    }

    public ScanProjectDetailsJsonReport(String path, String childPath, Map<String, ProjectDetails> projectNamesToDetails) {
        this.childPath = childPath;
        this.path = path;
        this.projectNamesToDetails = projectNamesToDetails;
    }

    public void createJsonObjectForProject() {
        JsonObject jsonProject = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        for (Map.Entry<String, ProjectDetails> entry : this.projectNamesToDetails.entrySet()) {
            JsonObject jsonData = new JsonObject();
            jsonData.addProperty(PROJECT_TOKEN, entry.getValue().getProjectToken());
            jsonData.addProperty(PROJECT_NAME, entry.getValue().getProjectName());
            jsonArray.add((JsonElement)jsonData);
        }
        jsonProject.add(PROJECTS, (JsonElement)jsonArray);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((JsonElement)jsonProject);
        File outputDir = new File(this.path).getAbsoluteFile();
        File workDir = new File(outputDir, this.childPath);
        this.generateJsonFile(json, "scanProjectDetails.json", workDir);
    }

    public void generateJsonFile(String jsonProject, String fileName, File outputDirectory) {
        this.logger.info("creating scanProjectDetails.json in {}", (Object)outputDirectory.toString());
        outputDirectory.mkdirs();
        File projectJsonFile = new File(outputDirectory, fileName);
        Path path = Paths.get(projectJsonFile.toString(), new String[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(jsonProject);
        }
        catch (Exception e) {
            this.logger.info("couldn't create json file {}", (Object)e.getMessage());
        }
    }
}

