/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.reports;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.whitesource.agent.api.dispatch.CheckPolicyComplianceResult;
import org.whitesource.agent.api.dispatch.UpdateInventoryResult;
import org.whitesource.agent.api.model.PolicyCheckResourceNode;
import org.whitesource.agent.api.model.ProjectDetails;
import org.whitesource.agent.api.model.RequestPolicyInfo;
import org.whitesource.config.scan.config.RequestConfiguration;
import org.whitesource.config.scan.config.SenderConfiguration;
import org.whitesource.utils.HttpApiQuery;
import org.whitesource.utils.logger.LoggerFactory;

public class ScanReport {
    private static final String AGENT = "agent";
    private static final String API_V_1_1 = "api/v1.1";
    private static final String REQUEST_TYPE = "requestType";
    private static final String ORG_TOKEN = "orgToken";
    private static final String REQUEST_TOKEN = "requestToken";
    private static final String USER_KEY = "userKey";
    private static final String PROJECT_TOKEN = "projectToken";
    private static final String GET_REQUEST_STATE = "getRequestState";
    private static final String GET_PROJECT_INVENTORY_REPORT = "getProjectInventory";
    private static final String LIBRARIES = "libraries";
    private static final String KEY_UUID = "keyUuid";
    private static final String FINISHED = "FINISHED";
    private static final String REQUEST_STATE = "requestState";
    private static final String FORMAT = "format";
    private static final String JSON = "json";
    private static final int CHECK_STATE_INTERVALS = 10000;
    private static final String POLICY_NAME = "policyName";
    private static final String STATUS = "status";
    private static final String POLICY_DETAILS = "policyDetails";
    private static final String ERROR_MESSAGE = "errorMessage";
    private static final String ALERT_TYPE = "alertType";
    private static final String NEW_MAJOR_VERSION = "NEW_MAJOR_VERSION";
    private static final String GET_PROJECT_ALERTS_BY_TYPE = "getProjectAlertsByType";
    private static final String TOTAL_LOW_VULNERABILITIES = "totalLowVulnerabilities";
    private static final String TOTAL_MEDIUM_VULNERABILITIES = "totalMediumVulnerabilities";
    private static final String TOTAL_HIGH_VULNERABILITIES = "totalHighVulnerabilities";
    private static final String LOW = "LOW";
    private static final String MEDIUM = "MEDIUM";
    private static final String HIGH = "HIGH";
    private static final String TOTAL_APPROVED = "totalApproved";
    private static final String TOTAL_REJECTED = "totalRejected";
    private static final String TOTAL_REASSIGNED = "totalReassigned";
    private static final String TOTAL_CONDITIONS = "totalConditions";
    private static final String TOTAL_ISSUES = "totalIssues";
    private static final String TOTAL_LIBRARIES_AFFECTED = "totalLibrariesAffected";
    private static final String APPROVE = "Approve";
    private static final String REJECT = "Reject";
    private static final String REASSIGN = "Reassign";
    private static final String CONDITIONS = "Conditions";
    private static final String ISSUE = "Issue";
    private static final String TOTAL_VULNERABLE = "totalVulnerable";
    private static final String NEW_VULNERABILITIES = "newVulnerabilities";
    private static final String OLD_VULNERABILITIES = "oldVulnerabilities";
    private static final String ANCIENT_VULNERABILITIES = "ancientVulnerabilities";
    private static final String TOTAL_OUTDATED = "totalOutdated";
    private static final String TOTAL_VULNERABLE_OUTDATED = "totalVulnerableOutdated";
    private static final String GET_PROJECT_CUSTOM_ATTRIBUTE_VALUES = "getProjectCustomAttributeValues";
    private static final String CUSTOM_ATTRIBUTE_VALUES = "customAttributeValues";
    private final Logger logger = LoggerFactory.getLogger(ScanReport.class);
    private final RequestConfiguration requestConfig;
    private final String apiUrl;
    private final long scanReportTimeout;
    private final String whiteSourceFolderPath;
    private Map<String, Integer> policiesCheckSummary = new LinkedHashMap<String, Integer>();
    private Map<String, Integer> vulnerabilityStatisticsSummary = new LinkedHashMap<String, Integer>();
    private List<String> newVersionLibraries = new ArrayList<String>();
    private HashMap<String, JsonObject> librariesByKeyUuid = new HashMap();

    public ScanReport(RequestConfiguration requestConfig, SenderConfiguration senderConfig, String whitesourceFolderPath) {
        this.requestConfig = requestConfig;
        this.apiUrl = senderConfig.getServiceUrl().replace(AGENT, API_V_1_1);
        this.scanReportTimeout = (long)senderConfig.getScanReportTimeoutMinutes() * 60000L;
        this.whiteSourceFolderPath = whitesourceFolderPath;
    }

    public void generateScanReport(UpdateInventoryResult updateInventoryResult, CheckPolicyComplianceResult checkPolicyComplianceResult) {
        this.logger.info("generating scan report");
        if (updateInventoryResult.getProjectNamesToDetails().isEmpty()) {
            this.logger.warn("unable to generate scan report - no project details available");
        } else if (this.checkRequestState(updateInventoryResult.getRequestToken())) {
            for (ProjectDetails projectDetails : updateInventoryResult.getProjectNamesToDetails().values()) {
                JsonElement projectInventoryReport = this.getProjectInventoryReport(projectDetails.getProjectToken(), checkPolicyComplianceResult);
                this.getPoliciesAndVulnerabilityStatistics(projectDetails.getProjectToken(), projectInventoryReport);
                if (projectInventoryReport == null) continue;
                try {
                    this.createReport(projectInventoryReport, projectDetails.getProjectName());
                }
                catch (IOException e) {
                    this.logger.warn("createReport IOException: {}", (Object)e.getMessage());
                    this.logger.debug("createReport IOException: {}", (Object[])e.getStackTrace());
                }
            }
        }
    }

    private void getPoliciesAndVulnerabilityStatistics(String projectToken, JsonElement projectInventoryReport) {
        this.initVulnerabilityStatisticsMap();
        this.getProjectAlert(projectToken);
        this.librariesByKeyUuid.forEach((key, library) -> this.checkLibraryVulnerability(library.getAsJsonObject()));
        if (projectInventoryReport != null) {
            JsonElement jsonPolicyStatisticsElement = new Gson().toJsonTree(this.policiesCheckSummary);
            JsonElement jsonVulnerabilityStatistics = new Gson().toJsonTree(this.vulnerabilityStatisticsSummary);
            projectInventoryReport.getAsJsonObject().add("policyStatistics", jsonPolicyStatisticsElement);
            projectInventoryReport.getAsJsonObject().add("vulnerabilityStatistics", jsonVulnerabilityStatistics);
        }
    }

    private boolean checkRequestState(String requestToken) {
        this.logger.debug("checking request state");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(REQUEST_TYPE, GET_REQUEST_STATE);
        params.put(ORG_TOKEN, this.requestConfig.getApiToken());
        params.put(REQUEST_TOKEN, requestToken);
        params.put(USER_KEY, this.requestConfig.getUserKey());
        long startTime = new Date().getTime();
        try {
            while (true) {
                long currTime;
                JsonElement jsonElement;
                if ((jsonElement = HttpApiQuery.getHttpResponse((String)this.apiUrl, params)) != null) {
                    if (this.isFinished(jsonElement)) {
                        return true;
                    }
                    if (this.isError(jsonElement)) {
                        return false;
                    }
                }
                if ((currTime = new Date().getTime()) >= startTime + this.scanReportTimeout) break;
                Thread.sleep(10000L);
            }
            this.logger.warn("The scan report could not be generated due to a connection timeout. Try scanning the project again");
            return false;
        }
        catch (InterruptedException e) {
            this.logger.warn("checkRequestState InterruptedException: {}", (Object)e.getMessage());
            this.logger.debug("checkRequestState InterruptedException: {}", (Object[])e.getStackTrace());
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            this.logger.warn("checkRequestState Exception: {}", (Object)e.getMessage());
            this.logger.debug("checkRequestState Exception: {}", (Object[])e.getStackTrace());
        }
        return false;
    }

    private boolean isFinished(JsonElement json) {
        JsonElement jsonElement = json.getAsJsonObject().get(REQUEST_STATE);
        if (jsonElement != null) {
            String state = jsonElement.getAsString();
            this.logger.debug("request state: {}", (Object)state);
            return state.equals(FINISHED);
        }
        return false;
    }

    private boolean isError(JsonElement json) {
        JsonElement errorMessage = json.getAsJsonObject().get(ERROR_MESSAGE);
        if (errorMessage != null) {
            this.logger.warn("Failing to generate scan report; error getting request state: {}", (Object)errorMessage.getAsString());
            return true;
        }
        return false;
    }

    private JsonElement getProjectInventoryReport(String projectToken, CheckPolicyComplianceResult checkPolicyComplianceResult) {
        this.logger.debug("getting project inventory report");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(REQUEST_TYPE, GET_PROJECT_INVENTORY_REPORT);
        params.put(ORG_TOKEN, this.requestConfig.getApiToken());
        params.put(PROJECT_TOKEN, projectToken);
        params.put(USER_KEY, this.requestConfig.getUserKey());
        params.put(FORMAT, JSON);
        JsonElement json = HttpApiQuery.getHttpResponse((String)this.apiUrl, params);
        if (json != null) {
            try {
                this.initPoliciesMap();
                JsonArray libraries = json.getAsJsonObject().get(LIBRARIES).getAsJsonArray();
                this.logger.debug("got {} libraries", (Object)libraries.size());
                libraries.forEach(library -> {
                    JsonElement keyUuid = library.getAsJsonObject().get(KEY_UUID);
                    this.librariesByKeyUuid.put(keyUuid.getAsString(), library.getAsJsonObject());
                });
                this.addCustomAttributesValues(projectToken);
                if (checkPolicyComplianceResult != null) {
                    checkPolicyComplianceResult.getExistingProjects().forEach((name, policyCheckResourceNode) -> this.findLibraryPolicy((PolicyCheckResourceNode)policyCheckResourceNode, this.librariesByKeyUuid));
                    checkPolicyComplianceResult.getNewProjects().forEach((name, policyCheckResourceNode) -> this.findLibraryPolicy((PolicyCheckResourceNode)policyCheckResourceNode, this.librariesByKeyUuid));
                }
                return json;
            }
            catch (Exception e) {
                this.logger.warn("getProjectInventoryReport Exception: {}", (Object)e.getMessage());
                this.logger.debug("getProjectInventoryReport Exception: {}", (Object[])e.getStackTrace());
            }
        }
        return null;
    }

    private void findLibraryPolicy(PolicyCheckResourceNode policyCheckResourceNode, HashMap<String, JsonObject> librariesByKuuid) {
        if (policyCheckResourceNode.getResource() != null) {
            this.logger.debug("matching policy of {}", (Object)policyCheckResourceNode.getResource().getDisplayName());
            String keyUuid = policyCheckResourceNode.getResource().getKeyUuid();
            JsonObject library = librariesByKuuid.get(keyUuid);
            if (library != null) {
                HashMap<String, String> policyDetailsMap = new HashMap<String, String>();
                RequestPolicyInfo policy = policyCheckResourceNode.getPolicy();
                if (policy == null) {
                    policyDetailsMap.put(POLICY_NAME, "");
                    policyDetailsMap.put(STATUS, "no policy applied");
                } else {
                    policyDetailsMap.put(POLICY_NAME, policy.getDisplayName());
                    policyDetailsMap.put(STATUS, policy.getActionType().toLowerCase());
                    this.checkPoliciesSummary(policy.getActionType());
                }
                JsonElement jsonElement = new Gson().toJsonTree(policyDetailsMap);
                library.add(POLICY_DETAILS, jsonElement);
            } else {
                this.logger.debug("no matching library");
            }
        }
        policyCheckResourceNode.getChildren().forEach(policyCheckResourceNodeChild -> this.findLibraryPolicy((PolicyCheckResourceNode)policyCheckResourceNodeChild, librariesByKuuid));
    }

    private void addCustomAttributesValues(String projectToken) {
        JsonArray projectCustomAttributeValues = this.getProjectCustomAttributeValues(projectToken);
        if (projectCustomAttributeValues != null) {
            projectCustomAttributeValues.forEach(jsonElement -> {
                String keyUuid = jsonElement.getAsJsonObject().get(KEY_UUID).getAsString();
                JsonObject library = this.librariesByKeyUuid.get(keyUuid);
                if (library != null) {
                    library.add(CUSTOM_ATTRIBUTE_VALUES, jsonElement.getAsJsonObject().get(CUSTOM_ATTRIBUTE_VALUES));
                }
            });
        }
        this.librariesByKeyUuid.values().stream().filter(library -> library.get(CUSTOM_ATTRIBUTE_VALUES) == null).forEach(library -> library.add(CUSTOM_ATTRIBUTE_VALUES, (JsonElement)new JsonArray()));
    }

    private JsonArray getProjectCustomAttributeValues(String projectToken) {
        this.logger.debug("getting project custom attributes values");
        JsonArray libraries = null;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(REQUEST_TYPE, GET_PROJECT_CUSTOM_ATTRIBUTE_VALUES);
        params.put(PROJECT_TOKEN, projectToken);
        params.put(USER_KEY, this.requestConfig.getUserKey());
        JsonElement json = HttpApiQuery.getHttpResponse((String)this.apiUrl, params);
        if (json != null) {
            libraries = json.getAsJsonObject().get(LIBRARIES).getAsJsonArray();
        }
        return libraries;
    }

    private void checkLibraryVulnerability(JsonObject library) {
        JsonArray vulnerabilitiesArray = library.getAsJsonObject().get("vulnerabilities").getAsJsonArray();
        int size = vulnerabilitiesArray.size();
        HashSet<String> librarySeverity = new HashSet<String>();
        TreeMap<Date, String> libraryPublishDate = new TreeMap<Date, String>();
        if (size > 0) {
            String libraryKeyUuid = library.getAsJsonObject().get(KEY_UUID).getAsString();
            this.calculateTotalVulnerableOutdated(libraryKeyUuid);
            for (int i = 0; i < size; ++i) {
                JsonObject vulnerabilityObject = (JsonObject)vulnerabilitiesArray.get(i);
                String severity = vulnerabilityObject.get("severity").getAsString();
                this.calculateTotalSeverity(severity);
                librarySeverity.add(severity);
                String libraryName = vulnerabilityObject.get("name").getAsString();
                String publishDate = vulnerabilityObject.get("publishDate").getAsString();
                try {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                    Date date = format.parse(publishDate);
                    libraryPublishDate.put(date, libraryName);
                    continue;
                }
                catch (Exception e) {
                    this.logger.info("ScanReport : Cannot parse library publish date");
                    this.logger.debug("ScanReport : Exception  {}", (Object)e.getMessage());
                }
            }
            this.vulnerabilityBasicStatistics(librarySeverity);
            Map.Entry oldestVulnerability = libraryPublishDate.pollFirstEntry();
            this.vulnerabilityStatisticsByDate((Date)oldestVulnerability.getKey());
        }
    }

    private void calculateTotalVulnerableOutdated(String libraryKeyUuid) {
        if (this.newVersionLibraries.contains(libraryKeyUuid)) {
            this.vulnerabilityStatisticsSummary.put(TOTAL_VULNERABLE_OUTDATED, this.vulnerabilityStatisticsSummary.get(TOTAL_VULNERABLE_OUTDATED) + 1);
        }
    }

    private void getProjectAlert(String projectToken) {
        JsonArray alerts;
        this.logger.debug("getting project inventory report");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(REQUEST_TYPE, GET_PROJECT_ALERTS_BY_TYPE);
        params.put(ORG_TOKEN, this.requestConfig.getApiToken());
        params.put(PROJECT_TOKEN, projectToken);
        params.put(USER_KEY, this.requestConfig.getUserKey());
        params.put(ALERT_TYPE, NEW_MAJOR_VERSION);
        JsonElement json = HttpApiQuery.getHttpResponse((String)this.apiUrl, params);
        if (json != null && (alerts = json.getAsJsonObject().getAsJsonArray("alerts")) != null) {
            this.vulnerabilityStatisticsSummary.put(TOTAL_OUTDATED, alerts.size());
            JsonArray alertsArray = alerts.getAsJsonArray();
            for (int i = 0; i < alertsArray.size(); ++i) {
                this.newVersionLibraries.add(alertsArray.get(i).getAsJsonObject().get("library").getAsJsonObject().get(KEY_UUID).getAsString());
            }
        }
    }

    private void calculateTotalSeverity(String severity) {
        switch (severity) {
            case "LOW": {
                this.vulnerabilityStatisticsSummary.put(TOTAL_LOW_VULNERABILITIES, this.vulnerabilityStatisticsSummary.get(TOTAL_LOW_VULNERABILITIES) + 1);
                break;
            }
            case "MEDIUM": {
                this.vulnerabilityStatisticsSummary.put(TOTAL_MEDIUM_VULNERABILITIES, this.vulnerabilityStatisticsSummary.get(TOTAL_MEDIUM_VULNERABILITIES) + 1);
                break;
            }
            case "HIGH": {
                this.vulnerabilityStatisticsSummary.put(TOTAL_HIGH_VULNERABILITIES, this.vulnerabilityStatisticsSummary.get(TOTAL_HIGH_VULNERABILITIES) + 1);
                break;
            }
            default: {
                this.logger.warn("Severity level - {} -  not supported", (Object)severity);
            }
        }
    }

    private void initVulnerabilityStatisticsMap() {
        this.vulnerabilityStatisticsSummary.put(LOW.toLowerCase(), 0);
        this.vulnerabilityStatisticsSummary.put(MEDIUM.toLowerCase(), 0);
        this.vulnerabilityStatisticsSummary.put(HIGH.toLowerCase(), 0);
        this.vulnerabilityStatisticsSummary.put(NEW_VULNERABILITIES, 0);
        this.vulnerabilityStatisticsSummary.put(OLD_VULNERABILITIES, 0);
        this.vulnerabilityStatisticsSummary.put(ANCIENT_VULNERABILITIES, 0);
        this.vulnerabilityStatisticsSummary.put(TOTAL_OUTDATED, 0);
        this.vulnerabilityStatisticsSummary.put(TOTAL_VULNERABLE_OUTDATED, 0);
        this.vulnerabilityStatisticsSummary.put(TOTAL_LOW_VULNERABILITIES, 0);
        this.vulnerabilityStatisticsSummary.put(TOTAL_MEDIUM_VULNERABILITIES, 0);
        this.vulnerabilityStatisticsSummary.put(TOTAL_HIGH_VULNERABILITIES, 0);
        this.vulnerabilityStatisticsSummary.put(TOTAL_VULNERABLE, 0);
    }

    private void initPoliciesMap() {
        this.policiesCheckSummary.put(TOTAL_APPROVED, 0);
        this.policiesCheckSummary.put(TOTAL_REJECTED, 0);
        this.policiesCheckSummary.put(TOTAL_REASSIGNED, 0);
        this.policiesCheckSummary.put(TOTAL_CONDITIONS, 0);
        this.policiesCheckSummary.put(TOTAL_ISSUES, 0);
        this.policiesCheckSummary.put(TOTAL_LIBRARIES_AFFECTED, 0);
    }

    private void checkPoliciesSummary(String actionType) {
        this.policiesCheckSummary.put(TOTAL_LIBRARIES_AFFECTED, this.policiesCheckSummary.get(TOTAL_LIBRARIES_AFFECTED) + 1);
        switch (actionType) {
            case "Approve": {
                this.policiesCheckSummary.put(TOTAL_APPROVED, this.policiesCheckSummary.get(TOTAL_APPROVED) + 1);
                break;
            }
            case "Reject": {
                this.policiesCheckSummary.put(TOTAL_REJECTED, this.policiesCheckSummary.get(TOTAL_REJECTED) + 1);
                break;
            }
            case "Reassign": {
                this.policiesCheckSummary.put(TOTAL_REASSIGNED, this.policiesCheckSummary.get(TOTAL_REASSIGNED) + 1);
                break;
            }
            case "Conditions": {
                this.policiesCheckSummary.put(TOTAL_CONDITIONS, this.policiesCheckSummary.get(TOTAL_CONDITIONS) + 1);
                break;
            }
            case "Issue": {
                this.policiesCheckSummary.put(TOTAL_ISSUES, this.policiesCheckSummary.get(TOTAL_ISSUES) + 1);
                break;
            }
            default: {
                this.logger.warn("Policy action type  - {} - not supported", (Object)actionType);
            }
        }
    }

    private void vulnerabilityBasicStatistics(Set severity) {
        this.vulnerabilityStatisticsSummary.put(TOTAL_VULNERABLE, this.vulnerabilityStatisticsSummary.get(TOTAL_VULNERABLE) + 1);
        if (severity.contains(HIGH)) {
            this.vulnerabilityStatisticsSummary.put(HIGH.toLowerCase(), this.vulnerabilityStatisticsSummary.get(HIGH.toLowerCase()) + 1);
        } else if (severity.contains(MEDIUM)) {
            this.vulnerabilityStatisticsSummary.put(MEDIUM.toLowerCase(), this.vulnerabilityStatisticsSummary.get(MEDIUM.toLowerCase()) + 1);
        } else if (severity.contains(LOW)) {
            this.vulnerabilityStatisticsSummary.put(LOW.toLowerCase(), this.vulnerabilityStatisticsSummary.get(LOW.toLowerCase()) + 1);
        }
    }

    private void vulnerabilityStatisticsByDate(Date publishDate) {
        Calendar oneMonthAgo = Calendar.getInstance();
        oneMonthAgo.add(2, -1);
        Calendar threeMonthsAgo = Calendar.getInstance();
        threeMonthsAgo.add(2, -3);
        if (publishDate.after(oneMonthAgo.getTime())) {
            this.vulnerabilityStatisticsSummary.put(NEW_VULNERABILITIES, this.vulnerabilityStatisticsSummary.get(NEW_VULNERABILITIES) + 1);
        }
        if (publishDate.before(oneMonthAgo.getTime()) && publishDate.after(threeMonthsAgo.getTime())) {
            this.vulnerabilityStatisticsSummary.put(OLD_VULNERABILITIES, this.vulnerabilityStatisticsSummary.get(OLD_VULNERABILITIES) + 1);
        }
        if (publishDate.before(threeMonthsAgo.getTime())) {
            this.vulnerabilityStatisticsSummary.put(ANCIENT_VULNERABILITIES, this.vulnerabilityStatisticsSummary.get(ANCIENT_VULNERABILITIES) + 1);
        }
    }

    private void createReport(JsonElement jsonElement, String projectName) throws IOException {
        File outputDir = new File(this.whiteSourceFolderPath).getAbsoluteFile();
        if (!outputDir.exists() && !outputDir.mkdir()) {
            throw new IOException("Unable to make output directory: " + outputDir);
        }
        File workDir = new File(outputDir, "whitesource");
        if (!workDir.exists() && !workDir.mkdir()) {
            throw new IOException("Unable to make output directory: " + workDir);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HHmmssZ");
        String dateStamp = sdf.format(new Date()).replace("_", "T");
        File requestFile = new File(workDir, projectName + "-" + dateStamp + "-scan_report.json");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(jsonElement);
        FileUtils.writeStringToFile((File)requestFile, (String)json, (String)"UTF-8");
        this.logger.info("scan report created successfully at {}", (Object)requestFile.getPath());
    }
}

