/*
 * Decompiled with CFR 0.152.
 */
package org.wicketopia.security.decorator;

import org.metastopheles.PropertyMetaData;
import org.metastopheles.annotation.PropertyDecorator;
import org.wicketopia.context.ContextPredicate;
import org.wicketopia.metadata.WicketopiaPropertyFacet;
import org.wicketopia.security.SecurityProvider;
import org.wicketopia.security.annotation.DisabledForRole;
import org.wicketopia.security.annotation.EnabledForRole;
import org.wicketopia.security.annotation.HiddenForRole;
import org.wicketopia.security.annotation.OptionalForRole;
import org.wicketopia.security.annotation.RequiredForRole;
import org.wicketopia.security.annotation.VisibleForRole;
import org.wicketopia.security.predicate.RequiredRolesPredicate;

public abstract class AbstractSecurityDecorators {
    private final SecurityProvider securityProvider;

    protected AbstractSecurityDecorators(SecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
    }

    @PropertyDecorator
    public void onDisabledForRole(PropertyMetaData propertyMetaData, DisabledForRole annot) {
        WicketopiaPropertyFacet.get((PropertyMetaData)propertyMetaData).setEnabled((ContextPredicate)new RequiredRolesPredicate(this.securityProvider, annot.value()), false);
    }

    @PropertyDecorator
    public void onEnabledForRole(PropertyMetaData propertyMetaData, EnabledForRole annot) {
        WicketopiaPropertyFacet.get((PropertyMetaData)propertyMetaData).setEnabled((ContextPredicate)new RequiredRolesPredicate(this.securityProvider, annot.value()), true);
    }

    @PropertyDecorator
    public void onHiddenForRole(PropertyMetaData propertyMetaData, HiddenForRole annot) {
        WicketopiaPropertyFacet.get((PropertyMetaData)propertyMetaData).setVisible((ContextPredicate)new RequiredRolesPredicate(this.securityProvider, annot.value()), false);
    }

    @PropertyDecorator
    public void onOptionalForRole(PropertyMetaData propertyMetaData, OptionalForRole annot) {
        WicketopiaPropertyFacet.get((PropertyMetaData)propertyMetaData).setRequired((ContextPredicate)new RequiredRolesPredicate(this.securityProvider, annot.value()), false);
    }

    @PropertyDecorator
    public void onRequiredForRole(PropertyMetaData propertyMetaData, RequiredForRole annot) {
        WicketopiaPropertyFacet.get((PropertyMetaData)propertyMetaData).setRequired((ContextPredicate)new RequiredRolesPredicate(this.securityProvider, annot.value()), true);
    }

    @PropertyDecorator
    public void onVisibleForRole(PropertyMetaData propertyMetaData, VisibleForRole annot) {
        WicketopiaPropertyFacet.get((PropertyMetaData)propertyMetaData).setVisible((ContextPredicate)new RequiredRolesPredicate(this.securityProvider, annot.value()), true);
    }
}

