/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.async.components;

import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.wicketstuff.async.components.InteractionState;
import org.wicketstuff.async.components.ProgressButton;
import org.wicketstuff.async.components.StateDescription;
import org.wicketstuff.async.components.TaskState;
import org.wicketstuff.async.task.AbstractTaskContainer;

public class ProgressBar
extends Panel {
    private final ProgressButton progressButton;
    private final Map<StateDescription, IModel<String>> stateCssClasses;

    public ProgressBar(String id, ProgressButton progressButton) {
        super(id);
        this.progressButton = progressButton;
        WebMarkupContainer wrapper = this.makeWrapper("wrapper");
        this.add(new Component[]{wrapper});
        Component bar = this.makeBar("bar").add(new Behavior[]{new AttributeAppender("style", (IModel)new TaskProgressPercentageStyleModel())});
        wrapper.add(new Component[]{bar});
        wrapper.add(new Component[]{new Label("message", (IModel)new TaskProgressMessageModel())});
        this.stateCssClasses = new HashMap<StateDescription, IModel<String>>();
        Behavior[] behaviorArray = new Behavior[1];
        ProgressButton progressButton2 = progressButton;
        ((Object)((Object)progressButton2)).getClass();
        behaviorArray[0] = new AttributeAppender("class", new ProgressButton.StateDispatcherModel(progressButton2, new Model(), this.stateCssClasses), " ");
        this.add(behaviorArray);
        progressButton.addRefreshDependant((Component)this);
        this.setOutputMarkupId(true);
    }

    private AbstractTaskContainer getTaskContainer() {
        return this.progressButton.getTaskContainer();
    }

    protected WebMarkupContainer makeWrapper(String id) {
        return new WebMarkupContainer(id);
    }

    protected WebMarkupContainer makeBar(String id) {
        return new WebMarkupContainer(id);
    }

    protected boolean isShowPercentage() {
        return true;
    }

    protected double getDefaultWidth() {
        return 0.0;
    }

    private int getPercentProgress() {
        double width = this.getTaskContainer().getProgress() == null ? this.getDefaultWidth() : this.getTaskContainer().getProgress().doubleValue();
        return (int)Math.round(Math.max(Math.min(width, 1.0), 0.0) * 100.0);
    }

    public void registerCssClassModel(IModel<String> textModel, TaskState taskState, InteractionState interactionState) {
        this.stateCssClasses.put(new StateDescription(taskState, interactionState), textModel);
    }

    public void registerCssClassModel(IModel<String> textModel, TaskState ... taskStates) {
        for (TaskState taskState : taskStates) {
            for (InteractionState interactionState : InteractionState.values()) {
                this.registerCssClassModel(textModel, taskState, interactionState);
            }
        }
    }

    public void registerCssClassModel(IModel<String> textModel, InteractionState ... interactionStates) {
        for (InteractionState interactionState : interactionStates) {
            for (TaskState taskState : TaskState.values()) {
                this.registerCssClassModel(textModel, taskState, interactionState);
            }
        }
    }

    private class TaskProgressPercentageStyleModel
    extends AbstractReadOnlyModel<String> {
        private TaskProgressPercentageStyleModel() {
        }

        public String getObject() {
            int percentProgress = ProgressBar.this.getPercentProgress();
            return String.format("width: %d%%;", percentProgress);
        }
    }

    private class TaskProgressMessageModel
    extends AbstractReadOnlyModel<String> {
        private TaskProgressMessageModel() {
        }

        public String getObject() {
            String message;
            Double progress = ProgressBar.this.getTaskContainer().getProgress();
            String suffix = "";
            if (ProgressBar.this.isShowPercentage() && progress != null) {
                suffix = String.format("(%d%%)", ProgressBar.this.getPercentProgress());
            }
            if ((message = ProgressBar.this.getTaskContainer().getProgressMessage()) == null) {
                message = "";
            }
            return String.format("%s %s", message, suffix);
        }
    }
}

