/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.async.components;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AbstractAjaxTimerBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxFallbackButton;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.time.Duration;
import org.wicketstuff.async.components.IRunnableFactory;
import org.wicketstuff.async.components.InteractionState;
import org.wicketstuff.async.components.StateDescription;
import org.wicketstuff.async.components.TaskState;
import org.wicketstuff.async.task.AbstractTaskContainer;

public class ProgressButton
extends AjaxFallbackButton {
    private final Map<StateDescription, IModel<String>> stateTextModels;
    private final Map<StateDescription, IModel<String>> stateCssClasses;
    private final Collection<Component> refreshDependants;
    private final IRunnableFactory runnableFactory;
    private final RefreshBehavior refreshBehavior;
    private IModel<? extends AbstractTaskContainer> taskContainerModel;

    public ProgressButton(String id, Form<?> form, IModel<? extends AbstractTaskContainer> taskContainerModel, Duration duration) {
        this(id, null, form, taskContainerModel, null, duration);
    }

    public ProgressButton(String id, IModel<String> model, Form<?> form, IModel<? extends AbstractTaskContainer> taskContainerModel, Duration duration) {
        this(id, model, form, taskContainerModel, null, duration);
    }

    public ProgressButton(String id, Form<?> form, IModel<? extends AbstractTaskContainer> taskContainerModel, IRunnableFactory runnableFactory, Duration duration) {
        this(id, null, form, taskContainerModel, runnableFactory, duration);
    }

    public ProgressButton(String id, IModel<String> model, Form<?> form, IModel<? extends AbstractTaskContainer> taskContainerModel, IRunnableFactory runnableFactory, Duration duration) {
        super(id, null, form);
        this.taskContainerModel = taskContainerModel;
        this.runnableFactory = runnableFactory;
        this.refreshDependants = new HashSet<Component>();
        this.refreshBehavior = new RefreshBehavior(duration);
        if (this.getTaskContainer().isRunning()) {
            this.add(new Behavior[]{this.refreshBehavior});
        }
        this.stateTextModels = new HashMap<StateDescription, IModel<String>>();
        this.setModel((IModel)new StateDispatcherModel<String>(this.getDefaultTextModel(model), this.stateTextModels));
        this.stateCssClasses = new HashMap<StateDescription, IModel<String>>();
        this.add(new Behavior[]{new AttributeAppender("class", new StateDispatcherModel(new Model(), this.stateCssClasses), " ")});
        this.setOutputMarkupId(true);
    }

    private IModel<String> getDefaultTextModel(IModel<String> userModel) {
        if (userModel == null) {
            return new Model();
        }
        return userModel;
    }

    public IModel<? extends AbstractTaskContainer> getTaskContainerModel() {
        return this.taskContainerModel;
    }

    public void setTaskContainerModel(IModel<? extends AbstractTaskContainer> taskContainerModel) {
        this.taskContainerModel = taskContainerModel;
    }

    protected AbstractTaskContainer getTaskContainer() {
        return (AbstractTaskContainer)this.taskContainerModel.getObject();
    }

    protected boolean isAllowStart() {
        return true;
    }

    protected boolean isAllowRestart() {
        return true;
    }

    protected boolean isAllowInterrupt() {
        return true;
    }

    boolean canStart() {
        return this.runnableFactory != null && this.isAllowStart() && !this.getTaskContainer().isSubmitted() && !this.getTaskContainer().isRunning();
    }

    boolean canRestart() {
        return this.runnableFactory != null && this.isAllowRestart() && this.getTaskContainer().isSubmitted() && !this.getTaskContainer().isRunning();
    }

    boolean canInterrupt() {
        return this.isAllowInterrupt() && !this.getTaskContainer().isCancelled() && this.getTaskContainer().isRunning();
    }

    protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
        super.onSubmit(target, form);
        if (this.canStart() || this.canRestart()) {
            this.getTaskContainer().submit(this.runnableFactory.getRunnable());
            this.onTaskStart(target);
        } else if (this.canInterrupt()) {
            this.getTaskContainer().cancel();
        } else {
            return;
        }
        if (target != null) {
            this.activateRefresh(target);
            this.renderAll(target);
        }
        this.concludeIfApplicable(target);
    }

    private void activateRefresh(AjaxRequestTarget target) {
        if (!this.getTaskContainer().isRunning()) {
            if (this.getBehaviors(RefreshBehavior.class).size() > 0) {
                this.refreshBehavior.stop(target);
            }
        } else if (this.getBehaviors(RefreshBehavior.class).size() == 0) {
            this.add(new Behavior[]{this.refreshBehavior});
        } else {
            this.refreshBehavior.restart(target);
        }
    }

    protected void refresh(AjaxRequestTarget target) {
        this.concludeIfApplicable(target);
        this.renderAll(target);
    }

    private void concludeIfApplicable(AjaxRequestTarget target) {
        if (!this.getTaskContainer().isRunning()) {
            if (target != null) {
                this.refreshBehavior.stop(target);
            }
            if (this.getTaskContainer().isFailed()) {
                this.onTaskError(target);
            } else if (!this.getTaskContainer().isCancelled()) {
                this.onTaskSuccess(target);
            } else {
                this.onTaskCancel(target);
            }
        }
    }

    private void renderAll(AjaxRequestTarget target) {
        target.add(new Component[]{this});
        for (Component c : this.refreshDependants) {
            target.add(new Component[]{c});
        }
    }

    public boolean isEnabled() {
        return super.isEnabled() && (this.canStart() || this.canRestart() || this.canInterrupt());
    }

    public void registerMessageModel(IModel<String> textModel, TaskState taskState, InteractionState interactionState) {
        this.stateTextModels.put(new StateDescription(taskState, interactionState), textModel);
    }

    public void registerMessageModel(IModel<String> textModel, TaskState ... taskStates) {
        for (TaskState taskState : taskStates) {
            for (InteractionState interactionState : InteractionState.values()) {
                this.registerMessageModel(textModel, taskState, interactionState);
            }
        }
    }

    public void registerMessageModel(IModel<String> textModel, InteractionState ... interactionStates) {
        for (InteractionState interactionState : interactionStates) {
            for (TaskState taskState : TaskState.values()) {
                this.registerMessageModel(textModel, taskState, interactionState);
            }
        }
    }

    public void registerCssClassModel(IModel<String> textModel, TaskState taskState, InteractionState interactionState) {
        this.stateCssClasses.put(new StateDescription(taskState, interactionState), textModel);
    }

    public void registerCssClassModel(IModel<String> textModel, TaskState ... taskStates) {
        for (TaskState taskState : taskStates) {
            for (InteractionState interactionState : InteractionState.values()) {
                this.registerCssClassModel(textModel, taskState, interactionState);
            }
        }
    }

    public void registerCssClassModel(IModel<String> textModel, InteractionState ... interactionStates) {
        for (InteractionState interactionState : interactionStates) {
            for (TaskState taskState : TaskState.values()) {
                this.registerCssClassModel(textModel, taskState, interactionState);
            }
        }
    }

    public void addRefreshDependant(Component refreshDependant) {
        this.refreshDependants.add(refreshDependant);
    }

    public void removeRefreshDependant(Component refreshDependant) {
        this.refreshDependants.remove(refreshDependant);
    }

    protected void onTaskStart(AjaxRequestTarget ajaxRequestTarget) {
    }

    protected void onTaskSuccess(AjaxRequestTarget ajaxRequestTarget) {
    }

    protected void onTaskCancel(AjaxRequestTarget ajaxRequestTarget) {
    }

    protected void onTaskError(AjaxRequestTarget ajaxRequestTarget) {
    }

    class StateDispatcherModel<T>
    extends AbstractReadOnlyModel<T> {
        private final IModel<T> defaultValue;
        private final Map<StateDescription, IModel<T>> stateValues;

        StateDispatcherModel(IModel<T> defaultValue, Map<StateDescription, IModel<T>> taskStateValues) {
            this.defaultValue = defaultValue;
            this.stateValues = taskStateValues;
        }

        public T getObject() {
            IModel<T> actualModel = this.getActualModel();
            if (actualModel == null) {
                return (T)this.defaultValue.getObject();
            }
            return (T)actualModel.getObject();
        }

        private IModel<T> getActualModel() {
            return this.stateValues.get(new StateDescription(TaskState.findRunningState(ProgressButton.this.getTaskContainer()), InteractionState.findInteractionState(ProgressButton.this)));
        }
    }

    private class RefreshBehavior
    extends AbstractAjaxTimerBehavior {
        public RefreshBehavior(Duration updateInterval) {
            super(updateInterval);
        }

        protected void onTimer(AjaxRequestTarget target) {
            ProgressButton.this.refresh(target);
        }

        public boolean canCallListenerInterface(Component component, Method method) {
            return component.isVisibleInHierarchy();
        }

        protected boolean shouldTrigger() {
            return !this.isStopped() && this.getComponent().findParent(Page.class) != null;
        }
    }
}

