/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.async.task;

import java.io.Serializable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.wicket.model.IDetachable;
import org.apache.wicket.model.LoadableDetachableModel;
import org.wicketstuff.async.task.IProgressObservableRunnable;
import org.wicketstuff.async.task.ITaskManagerHook;

public abstract class AbstractTaskContainer
implements Serializable,
IDetachable {
    private final String id;
    private final LoadableDetachableModel<ITaskManagerHook> taskManagerHook;

    protected AbstractTaskContainer(String id) {
        this.id = id;
        this.taskManagerHook = new LoadableDetachableModel<ITaskManagerHook>(){

            protected ITaskManagerHook load() {
                return AbstractTaskContainer.this.load();
            }
        };
    }

    protected abstract ITaskManagerHook load();

    public String getId() {
        return this.id;
    }

    private Future<?> getFuture() {
        return ((ITaskManagerHook)this.taskManagerHook.getObject()).getFuture();
    }

    private Runnable getRunnable() {
        return ((ITaskManagerHook)this.taskManagerHook.getObject()).getRunnable();
    }

    private IProgressObservableRunnable getProgressObservableRunnable() {
        if (this.getRunnable() == null) {
            return null;
        }
        if (this.getRunnable() instanceof IProgressObservableRunnable) {
            return (IProgressObservableRunnable)this.getRunnable();
        }
        return null;
    }

    public boolean isSubmitted() {
        return this.getRunnable() != null;
    }

    public boolean isRunning() {
        return this.isSubmitted() && !this.getFuture().isDone();
    }

    public boolean isComplete() {
        return this.getFuture().isDone() && !this.getFuture().isCancelled() && !this.isFailed();
    }

    public boolean isFailed() {
        return this.evaluateExecutionError() != null;
    }

    public boolean isCancelled() {
        return this.getFuture().isCancelled();
    }

    public Throwable getExecutionError() {
        return this.evaluateExecutionError();
    }

    public void submit(Runnable runnable) {
        ((ITaskManagerHook)this.taskManagerHook.getObject()).submit(runnable, true);
    }

    public void cancel() {
        this.getFuture().cancel(true);
    }

    private Throwable evaluateExecutionError() {
        try {
            this.getFuture().get(1L, TimeUnit.MICROSECONDS);
            return null;
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (ExecutionException e) {
            return e.getCause();
        }
        catch (CancellationException e) {
            return null;
        }
        catch (TimeoutException e) {
            return null;
        }
    }

    public Double getProgress() {
        IProgressObservableRunnable runnable = this.getProgressObservableRunnable();
        if (runnable != null) {
            return runnable.getProgress();
        }
        return null;
    }

    public String getProgressMessage() {
        IProgressObservableRunnable runnable = this.getProgressObservableRunnable();
        if (runnable != null) {
            return runnable.getProgressMessage();
        }
        return null;
    }

    public void detach() {
        this.taskManagerHook.detach();
    }
}

