/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.async.task;

import com.google.common.collect.MapMaker;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.wicketstuff.async.task.AbstractTaskContainer;
import org.wicketstuff.async.task.DefaultTaskManagerHook;
import org.wicketstuff.async.task.ITaskManager;
import org.wicketstuff.async.task.ITaskManagerHook;

public abstract class DefaultTaskManager
implements ITaskManager {
    private static final DefaultTaskManager INSTANCE = new DefaultTaskManager(){

        @Override
        protected AbstractTaskContainer makeTaskContainer(String id) {
            return new SingletonTaskManagerTaskRepresentation(id);
        }
    };
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    private final ConcurrentMap<String, ITaskManagerHook> taskManagerHooks = new MapMaker().weakValues().makeMap();
    private final ConcurrentNavigableMap<Long, ITaskManagerHook> taskManagerRemovalRegister = new ConcurrentSkipListMap<Long, ITaskManagerHook>();
    private final ConcurrentMap<ITaskManagerHook, Long> taskManagerRemovalBackRegister = new MapMaker().weakKeys().makeMap();

    public static DefaultTaskManager getInstance() {
        return INSTANCE;
    }

    @Override
    public AbstractTaskContainer makeContainer(long lifeTime, TimeUnit unit) {
        return this.makeOrRenewContainer(UUID.randomUUID().toString(), lifeTime, unit);
    }

    @Override
    public AbstractTaskContainer makeOrRenewContainer(String id, long lifeTime, TimeUnit unit) {
        this.cleanUp();
        this.taskManagerHooks.putIfAbsent(id, this.makeTaskManagerHook(id));
        this.registerRemoval(id, lifeTime, unit);
        return this.makeTaskContainer(id);
    }

    private void registerRemoval(String id, long lifeTime, TimeUnit unit) {
        ITaskManagerHook hook = (ITaskManagerHook)this.taskManagerHooks.get(id);
        if (hook != null) {
            long removalTime = unit.toMillis(lifeTime) + System.currentTimeMillis();
            Long currentRemovalTime = (Long)this.taskManagerRemovalBackRegister.get(hook);
            if (currentRemovalTime != null) {
                this.taskManagerRemovalRegister.remove(currentRemovalTime);
            }
            --removalTime;
            do {
                this.taskManagerRemovalRegister.putIfAbsent(++removalTime, hook);
            } while (this.taskManagerRemovalRegister.get(removalTime) != hook);
            this.taskManagerRemovalBackRegister.put(hook, removalTime);
        }
    }

    @Override
    public AbstractTaskContainer getContainerOrFail(String id) {
        if (!this.taskManagerHooks.containsKey(id)) {
            throw new IllegalArgumentException(String.format("Id %s is not registered", id));
        }
        return this.makeTaskContainer(id);
    }

    protected ITaskManagerHook findHookForId(String id) {
        return (ITaskManagerHook)this.taskManagerHooks.get(id);
    }

    protected Future<?> submit(Runnable runnable) {
        return this.executorService.submit(runnable);
    }

    protected abstract AbstractTaskContainer makeTaskContainer(String var1);

    protected ITaskManagerHook makeTaskManagerHook(String id) {
        return new DefaultTaskManagerHook(id);
    }

    @Override
    public void cleanUp() {
        this.taskManagerRemovalRegister.headMap((Object)System.currentTimeMillis()).clear();
    }

    private static class SingletonTaskManagerTaskRepresentation
    extends AbstractTaskContainer {
        private SingletonTaskManagerTaskRepresentation(String id) {
            super(id);
        }

        @Override
        protected ITaskManagerHook load() {
            return INSTANCE.findHookForId(this.getId());
        }
    }
}

